/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.http;

import io.jboot.components.http.HttpProxyInfo;
import io.jboot.components.http.JbootHttpConfig;
import io.jboot.components.http.JbootHttpManager;
import io.jboot.utils.StrUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.Proxy;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;

public class JbootHttpRequest {
    public static final String METHOD_GET = "GET";
    public static final String METHOD_POST = "POST";
    public static final String METHOD_HEAD = "HEAD";
    public static final String METHOD_OPTIONS = "OPTIONS";
    public static final String METHOD_PUT = "PUT";
    public static final String METHOD_PATCH = "PATCH";
    public static final String METHOD_DELETE = "DELETE";
    public static final String METHOD_TRACE = "TRACE";
    public static final int READ_TIME_OUT = 10000;
    public static final int CONNECT_TIME_OUT = 5000;
    public static final String CHAR_SET = "UTF-8";
    public static final String CONTENT_TYPE_TEXT = "text/plain; charset=utf-8";
    public static final String CONTENT_TYPE_JSON = "application/json; charset=utf-8";
    public static final String CONTENT_TYPE_URL_ENCODED = "application/x-www-form-urlencoded; charset=utf-8";
    private String requestUrl;
    private Map<String, String> headers;
    private Map<String, Object> params;
    private String method = "GET";
    private String charset = "UTF-8";
    private boolean multipartFormData = false;
    private String certPath;
    private String certPass;
    private int readTimeOut;
    private int connectTimeOut;
    private String contentType;
    private File downloadFile;
    private String bodyContent;
    private boolean readBody = true;
    private boolean instanceFollowRedirects = true;
    private SSLContext sslContext;
    private HttpProxyInfo httpProxyInfo;

    public static JbootHttpRequest create(String url) {
        return new JbootHttpRequest(url);
    }

    public static JbootHttpRequest create(String url, String method) {
        JbootHttpRequest request = new JbootHttpRequest(url);
        request.setMethod(method);
        return request;
    }

    public static JbootHttpRequest create(String url, Map<String, Object> params) {
        JbootHttpRequest request = new JbootHttpRequest(url);
        request.setParams(params);
        return request;
    }

    public static JbootHttpRequest create(String url, Map<String, Object> params, String method) {
        JbootHttpRequest request = new JbootHttpRequest(url);
        request.setMethod(method);
        request.setParams(params);
        return request;
    }

    public JbootHttpRequest() {
        JbootHttpConfig config = JbootHttpManager.me().getHttpConfig();
        if (StrUtil.isNotBlank(config.getCertPath())) {
            this.certPath = config.getCertPath();
        }
        if (StrUtil.isNotBlank(config.getCertPass())) {
            this.certPass = config.getCertPass();
        }
        this.readTimeOut = config.getReadTimeOut();
        this.connectTimeOut = config.getConnectTimeOut();
        this.contentType = config.getContentType();
        this.httpProxyInfo = config.getHttpProxyInfo();
    }

    public JbootHttpRequest(String url) {
        this();
        this.requestUrl = url;
    }

    public void addParam(String key, Object value) {
        if (this.params == null) {
            this.params = new LinkedHashMap<String, Object>();
        }
        if (value instanceof File) {
            this.setMultipartFormData(true);
        }
        this.params.put(key, value);
    }

    public void addParams(Map<String, Object> map) {
        if (this.params == null) {
            this.params = new LinkedHashMap<String, Object>();
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            if (entry.getValue() instanceof File) {
                this.setMultipartFormData(true);
            }
            this.params.put(entry.getKey(), entry.getValue());
        }
    }

    public void setRequestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
    }

    public String getCertPath() {
        return this.certPath;
    }

    public InputStream getCertInputStream() throws FileNotFoundException {
        if (StrUtil.isBlank((String)this.certPath)) {
            return null;
        }
        if (this.certPath.toLowerCase().startsWith("classpath:")) {
            String path = this.certPath.substring(10).trim();
            InputStream inStream = this.getClassLoader().getResourceAsStream(path);
            if (inStream == null) {
                inStream = this.getClassLoader().getResourceAsStream("webapp/" + path);
            }
            if (inStream == null) {
                throw new FileNotFoundException("Can not load resource: " + path + " in classpath.");
            }
            return inStream;
        }
        return new FileInputStream(this.certPath);
    }

    private ClassLoader getClassLoader() {
        ClassLoader ret = Thread.currentThread().getContextClassLoader();
        return ret != null ? ret : this.getClass().getClassLoader();
    }

    public void setCertPath(String certPath) {
        this.certPath = certPath;
    }

    public String getCertPass() {
        return this.certPass;
    }

    public void setCertPass(String certPass) {
        this.certPass = certPass;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public int getReadTimeOut() {
        return this.readTimeOut;
    }

    public void setReadTimeOut(int readTimeOut) {
        this.readTimeOut = readTimeOut;
    }

    public int getConnectTimeOut() {
        return this.connectTimeOut;
    }

    public void setConnectTimeOut(int connectTimeOut) {
        this.connectTimeOut = connectTimeOut;
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void addHeader(String key, String value) {
        if (this.headers == null) {
            this.headers = new LinkedHashMap<String, String>();
        }
        this.headers.put(key, value);
    }

    public void addHeaders(Map<String, String> headers) {
        if (headers == null || headers.isEmpty()) {
            return;
        }
        if (this.headers == null) {
            this.headers = new LinkedHashMap<String, String>();
        }
        this.headers.putAll(headers);
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public void setParams(Map<String, Object> params) {
        if (params == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if (entry.getValue() == null || !(entry.getValue() instanceof File)) continue;
            this.setMultipartFormData(true);
        }
        this.params = params;
    }

    public boolean isPostRequest() {
        return METHOD_POST.equalsIgnoreCase(this.method);
    }

    public boolean isPutRequest() {
        return METHOD_PUT.equalsIgnoreCase(this.method);
    }

    public boolean isPostOrPutRequest() {
        return this.isPostRequest() || this.isPutRequest();
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public boolean isMultipartFormData() {
        return this.multipartFormData;
    }

    public void setMultipartFormData(boolean multipartFormData) {
        this.multipartFormData = multipartFormData;
    }

    public File getDownloadFile() {
        return this.downloadFile;
    }

    public void setDownloadFile(File downloadFile) {
        this.downloadFile = downloadFile;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getBodyContent() {
        return this.bodyContent;
    }

    public String getUploadBodyString() {
        if (this.bodyContent != null) {
            return this.bodyContent;
        }
        return this.buildParams();
    }

    public void setBodyContent(String bodyContent) {
        this.bodyContent = bodyContent;
    }

    private String buildParams() {
        return StrUtil.mapToQueryString(this.getParams());
    }

    public void appendParasToUrl() {
        String params = this.buildParams();
        if (StrUtil.isBlank((String)params)) {
            return;
        }
        String originUrl = this.getRequestUrl();
        originUrl = originUrl.contains("?") ? originUrl + "&" + params : originUrl + "?" + params;
        this.setRequestUrl(originUrl);
    }

    public boolean isHttps() {
        return this.requestUrl != null && this.requestUrl.toLowerCase().startsWith("https");
    }

    public boolean isReadBody() {
        return this.readBody;
    }

    public void setReadBody(boolean readBody) {
        this.readBody = readBody;
    }

    public boolean isInstanceFollowRedirects() {
        return this.instanceFollowRedirects;
    }

    public void setInstanceFollowRedirects(boolean instanceFollowRedirects) {
        this.instanceFollowRedirects = instanceFollowRedirects;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public HttpProxyInfo getHttpProxyInfo() {
        return this.httpProxyInfo;
    }

    public void setHttpProxyInfo(HttpProxyInfo httpProxyInfo) {
        this.httpProxyInfo = httpProxyInfo;
    }

    public Proxy getProxy() {
        return this.httpProxyInfo != null ? this.httpProxyInfo.getProxy() : null;
    }
}

