/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.http;

import io.jboot.Jboot;
import io.jboot.components.http.JbootHttp;
import io.jboot.components.http.JbootHttpConfig;
import io.jboot.components.http.jboot.JbootHttpImpl;
import io.jboot.components.http.okhttp.OKHttpImpl;
import io.jboot.core.spi.JbootSpiLoader;

public class JbootHttpManager {
    private static JbootHttpManager me = new JbootHttpManager();
    private JbootHttp jbootHttp;
    private JbootHttpConfig httpConfig = Jboot.config(JbootHttpConfig.class);

    public static JbootHttpManager me() {
        return me;
    }

    private JbootHttpManager() {
    }

    public JbootHttp getJbootHttp() {
        if (this.jbootHttp == null) {
            this.jbootHttp = this.buildJbootHttp();
        }
        return this.jbootHttp;
    }

    public JbootHttpConfig getHttpConfig() {
        return this.httpConfig;
    }

    private JbootHttp buildJbootHttp() {
        switch (this.httpConfig.getType()) {
            case "default": {
                return new JbootHttpImpl();
            }
            case "okhttp": {
                return new OKHttpImpl();
            }
            case "httpclient": {
                throw new RuntimeException("not finished!!!!");
            }
        }
        return JbootSpiLoader.load(JbootHttp.class, this.httpConfig.getType());
    }
}

