/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.http;

import io.jboot.utils.StrUtil;
import java.io.Serializable;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;

public class HttpProxyInfo
implements Serializable {
    private String proxyHost;
    private Integer proxyPort;
    private String proxyUser;
    private String proxyPassword;
    private Proxy proxy;

    public HttpProxyInfo() {
    }

    public HttpProxyInfo(String proxyHost, Integer proxyPort) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
    }

    public HttpProxyInfo(String proxyHost, Integer proxyPort, String proxyUser, String proxyPassword) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.proxyUser = proxyUser;
        this.proxyPassword = proxyPassword;
        this.setAuthenticator();
    }

    public void setAuthenticator() {
        if (StrUtil.isNotBlank(this.proxyUser) && StrUtil.isNotBlank(this.proxyPassword)) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(HttpProxyInfo.this.proxyUser, HttpProxyInfo.this.proxyPassword.toCharArray());
                }
            });
        }
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public Proxy getProxy() {
        if (this.proxy == null) {
            this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.getProxyHost(), (int)this.getProxyPort()));
        }
        return this.proxy;
    }
}

