/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.gateway.discovery;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingFactory;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import com.alibaba.nacos.api.naming.pojo.Instance;
import io.jboot.Jboot;
import io.jboot.app.config.support.nacos.NacosServerConfig;
import io.jboot.components.gateway.discovery.GatewayDiscovery;
import io.jboot.components.gateway.discovery.GatewayDiscoveryConfig;
import io.jboot.components.gateway.discovery.GatewayDiscoveryListener;
import io.jboot.components.gateway.discovery.GatewayDiscoveryManager;
import io.jboot.components.gateway.discovery.GatewayInstance;
import io.jboot.utils.StrUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class NacosGatewayDiscovery
implements GatewayDiscovery {
    private GatewayDiscoveryConfig discoveryConfig = GatewayDiscoveryManager.me().getDiscoveryConfig();
    private NacosServerConfig nacosServerConfig = Jboot.config(NacosServerConfig.class, "jboot.gateway.discovery.nacos");
    private NamingService namingService;

    public NacosGatewayDiscovery() {
        try {
            this.namingService = NamingFactory.createNamingService((Properties)this.nacosServerConfig.toProperties());
        }
        catch (NacosException e) {
            throw new RuntimeException("Can not create Nacos NamingService for gateway discovry. ", e);
        }
    }

    @Override
    public void registerInstance(GatewayInstance instance) {
        try {
            this.namingService.registerInstance(instance.getServiceName(), this.discoveryConfig.getGroup(), this.gatewayInstance2NacosInstance(instance));
        }
        catch (NacosException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void deregisterInstance(GatewayInstance instance) {
        try {
            this.namingService.deregisterInstance(instance.getServiceName(), this.discoveryConfig.getGroup(), this.gatewayInstance2NacosInstance(instance));
        }
        catch (NacosException e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<GatewayInstance> getAllInstances(String serviceName) {
        try {
            List nacosInstanceList = this.namingService.getAllInstances(serviceName, this.discoveryConfig.getGroup());
            if (nacosInstanceList != null && !nacosInstanceList.isEmpty()) {
                ArrayList<GatewayInstance> retList = new ArrayList<GatewayInstance>();
                for (Instance nacosInstance : nacosInstanceList) {
                    retList.add(this.nacosInstance2GatewayInstance(nacosInstance));
                }
                return retList;
            }
        }
        catch (NacosException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public List<GatewayInstance> selectInstances(String serviceName, boolean healthy) {
        try {
            List nacosInstanceList = this.namingService.selectInstances(serviceName, this.discoveryConfig.getGroup(), healthy);
            if (nacosInstanceList != null && !nacosInstanceList.isEmpty()) {
                ArrayList<GatewayInstance> retList = new ArrayList<GatewayInstance>();
                for (Instance nacosInstance : nacosInstanceList) {
                    retList.add(this.nacosInstance2GatewayInstance(nacosInstance));
                }
                return retList;
            }
        }
        catch (NacosException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void subscribe(String serviceName, GatewayDiscoveryListener listener) {
        try {
            this.namingService.subscribe(serviceName, this.discoveryConfig.getGroup(), event -> {
                GatewayDiscoveryListener.EventInfo eventInfo = new GatewayDiscoveryListener.EventInfo();
                eventInfo.setServiceName(((NamingEvent)event).getServiceName());
                List nacosInstanceList = ((NamingEvent)event).getInstances();
                if (nacosInstanceList != null && !nacosInstanceList.isEmpty()) {
                    for (Instance nacosInstance : nacosInstanceList) {
                        GatewayInstance instance = this.nacosInstance2GatewayInstance(nacosInstance);
                        instance.setServiceName(eventInfo.getServiceName());
                        eventInfo.addInstances(instance);
                    }
                }
                listener.onEvent(eventInfo);
            });
        }
        catch (NacosException e) {
            e.printStackTrace();
        }
    }

    private GatewayInstance nacosInstance2GatewayInstance(Instance nacosInstance) {
        if (nacosInstance == null) {
            return null;
        }
        GatewayInstance instance = new GatewayInstance();
        instance.setHost(nacosInstance.getIp());
        instance.setPort(nacosInstance.getPort());
        instance.setServiceName(instance.getServiceName());
        instance.setHealthy(nacosInstance.isHealthy());
        Map metadata = nacosInstance.getMetadata();
        if (metadata != null && metadata.containsKey("uri")) {
            instance.setUri((String)metadata.get("uri"));
        }
        return instance;
    }

    private Instance gatewayInstance2NacosInstance(GatewayInstance gatewayInstance) {
        if (gatewayInstance == null) {
            return null;
        }
        Instance instance = new Instance();
        instance.setIp(gatewayInstance.getHost());
        instance.setPort(gatewayInstance.getPort());
        instance.setServiceName(instance.getServiceName());
        instance.setHealthy(gatewayInstance.isHealthy());
        if (StrUtil.isNotBlank(gatewayInstance.getUri())) {
            instance.addMetadata("uri", gatewayInstance.getUri());
        }
        return instance;
    }
}

