/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.gateway.discovery;

import io.jboot.Jboot;
import io.jboot.utils.NetUtil;
import io.jboot.utils.StrUtil;

public class GatewayInstanceConfig {
    private String name;
    private String uriScheme = "http";
    private String uriHost;
    private int uriPort;
    private String uriPath;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUriScheme() {
        return this.uriScheme;
    }

    public void setUriScheme(String uriScheme) {
        this.uriScheme = uriScheme;
    }

    public String getUriHost() {
        return this.uriHost;
    }

    public void setUriHost(String uriHost) {
        this.uriHost = uriHost;
    }

    public int getUriPort() {
        return this.uriPort;
    }

    public void setUriPort(int uriPort) {
        this.uriPort = uriPort;
    }

    public String getUriPath() {
        return this.uriPath;
    }

    public void setUriPath(String uriPath) {
        this.uriPath = uriPath;
    }

    public String toUri() {
        StringBuilder sb = new StringBuilder(this.uriScheme).append("://");
        if (StrUtil.isNotBlank(this.uriHost)) {
            sb.append(this.uriHost);
        } else {
            sb.append(NetUtil.getLocalIpAddress());
        }
        if (this.uriPort == 0) {
            this.uriPort = Integer.parseInt(Jboot.configValue("undertow.port", "8080"));
        }
        sb.append(":").append(this.uriPort);
        if (StrUtil.isNotBlank(this.uriPath)) {
            sb.append(this.uriPath);
        }
        return sb.toString();
    }
}

