/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.gateway.discovery;

import io.jboot.Jboot;
import io.jboot.components.gateway.discovery.GatewayDiscovery;
import io.jboot.components.gateway.discovery.GatewayDiscoveryConfig;
import io.jboot.components.gateway.discovery.GatewayInstance;
import io.jboot.components.gateway.discovery.GatewayInstanceConfig;
import io.jboot.components.gateway.discovery.NacosGatewayDiscovery;
import io.jboot.core.spi.JbootSpiLoader;
import io.jboot.utils.ConfigUtil;
import io.jboot.utils.NetUtil;
import java.util.Map;

public class GatewayDiscoveryManager {
    private static GatewayDiscoveryManager manager = new GatewayDiscoveryManager();
    private GatewayDiscoveryConfig discoveryConfig;
    private GatewayDiscovery gatewayDiscovery;
    private boolean isInited = false;

    private GatewayDiscoveryManager() {
    }

    public static GatewayDiscoveryManager me() {
        return manager;
    }

    public void init() {
        this.discoveryConfig = Jboot.config(GatewayDiscoveryConfig.class);
        this.gatewayDiscovery = this.createDiscovery(this.discoveryConfig);
        this.exportLocalInstance(this.gatewayDiscovery);
        this.isInited = true;
    }

    private void exportLocalInstance(GatewayDiscovery gatewayDiscovery) {
        if (gatewayDiscovery == null) {
            return;
        }
        Map<String, GatewayInstanceConfig> instanceConfigMap = ConfigUtil.getConfigModels(GatewayInstanceConfig.class, "jboot.gateway.instance");
        for (GatewayInstanceConfig instanceConfig : instanceConfigMap.values()) {
            GatewayInstance instance = new GatewayInstance();
            instance.setHealthy(true);
            instance.setServiceName(instanceConfig.getName());
            instance.setUri(instanceConfig.toUri());
            instance.setHost(NetUtil.getLocalIpAddress());
            instance.setPort(Integer.parseInt(Jboot.configValue("undertow.port", "8080")));
            gatewayDiscovery.registerInstance(instance);
        }
    }

    public GatewayDiscovery getGatewayDiscovery() {
        if (!this.isInited) {
            this.init();
        }
        return this.gatewayDiscovery;
    }

    public GatewayDiscoveryConfig getDiscoveryConfig() {
        return this.discoveryConfig;
    }

    public GatewayDiscovery createDiscovery(GatewayDiscoveryConfig config) {
        if (config == null || !config.isConfigOk() || !config.isEnable()) {
            return null;
        }
        switch (config.getType()) {
            case "nacos": {
                return new NacosGatewayDiscovery();
            }
        }
        return JbootSpiLoader.load(GatewayDiscovery.class, config.getType());
    }
}

