/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.gateway;

import io.jboot.components.gateway.GatewayErrorRender;
import io.jboot.components.gateway.JbootGatewayConfig;
import io.jboot.components.gateway.JbootGatewayHealthChecker;
import io.jboot.components.gateway.discovery.GatewayDiscovery;
import io.jboot.components.gateway.discovery.GatewayDiscoveryManager;
import io.jboot.components.gateway.discovery.GatewayInstance;
import io.jboot.utils.ConfigUtil;
import io.jboot.utils.StrUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;

public class JbootGatewayManager {
    private static JbootGatewayManager me = new JbootGatewayManager();
    private Map<String, JbootGatewayConfig> configMap;
    private GatewayErrorRender gatewayErrorRender;
    private GatewayDiscovery discovery;

    public static JbootGatewayManager me() {
        return me;
    }

    private JbootGatewayManager() {
        this.initDiscovery();
        this.initConfigs();
    }

    private void initConfigs() {
        Map<String, JbootGatewayConfig> configMap = ConfigUtil.getConfigModels(JbootGatewayConfig.class, "jboot.gateway");
        for (Map.Entry<String, JbootGatewayConfig> entry : configMap.entrySet()) {
            if ("discovery".equals(entry.getKey()) || "instance".equals(entry.getKey())) continue;
            JbootGatewayConfig config = entry.getValue();
            if (StrUtil.isBlank((String)config.getName())) {
                config.setName(entry.getKey());
            }
            this.registerConfig(config);
        }
    }

    private void initDiscovery() {
        this.discovery = GatewayDiscoveryManager.me().getGatewayDiscovery();
    }

    public boolean isConfigOk() {
        return this.configMap != null && !this.configMap.isEmpty();
    }

    public void registerConfig(JbootGatewayConfig config) {
        if (this.configMap == null) {
            this.configMap = new ConcurrentHashMap<String, JbootGatewayConfig>();
        }
        this.configMap.put(config.getName(), config);
        if (this.discovery != null) {
            List<GatewayInstance> healthyInstances = this.discovery.selectInstances(config.getName(), true);
            this.syncDiscoveryUris(healthyInstances, config);
            this.discovery.subscribe(config.getName(), eventInfo -> {
                List<GatewayInstance> changedInstances = eventInfo.getInstances();
                this.syncDiscoveryUris(changedInstances, config);
            });
        }
        if (config.isEnable()) {
            JbootGatewayHealthChecker.me().start();
        }
    }

    private void syncDiscoveryUris(List<GatewayInstance> instances, JbootGatewayConfig config) {
        if (instances == null) {
            config.syncDiscoveryUris(null);
        } else {
            HashSet<String> uris = new HashSet<String>();
            instances.forEach(instance -> {
                if (instance.isHealthy()) {
                    uris.add(instance.getUri());
                }
            });
            config.syncDiscoveryUris(uris);
        }
    }

    public JbootGatewayConfig removeConfig(String name) {
        return this.configMap == null ? null : this.configMap.remove(name);
    }

    public JbootGatewayConfig getConfig(String name) {
        return this.configMap == null ? null : this.configMap.get(name);
    }

    public Map<String, JbootGatewayConfig> getConfigMap() {
        return this.configMap;
    }

    public JbootGatewayConfig matchingConfig(HttpServletRequest req) {
        if (this.configMap != null && !this.configMap.isEmpty()) {
            for (JbootGatewayConfig config : this.configMap.values()) {
                if (!config.isEnable() || !config.matches(req)) continue;
                return config;
            }
        }
        return null;
    }

    public GatewayErrorRender getGatewayErrorRender() {
        return this.gatewayErrorRender;
    }

    public void setGatewayErrorRender(GatewayErrorRender gatewayErrorRender) {
        this.gatewayErrorRender = gatewayErrorRender;
    }
}

