/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.gateway;

import com.jfinal.kit.LogKit;
import io.jboot.components.gateway.JbootGatewayConfig;
import io.jboot.components.gateway.JbootGatewayManager;
import io.jboot.components.http.JbootHttpRequest;
import io.jboot.utils.HttpUtil;
import io.jboot.utils.NamedThreadFactory;
import io.jboot.utils.StrUtil;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class JbootGatewayHealthChecker
implements Runnable {
    private static JbootGatewayHealthChecker me = new JbootGatewayHealthChecker();
    private ScheduledThreadPoolExecutor fixedScheduler;
    private long fixedSchedulerInitialDelay = 10L;
    private long fixedSchedulerDelay = 30L;

    public static JbootGatewayHealthChecker me() {
        return me;
    }

    public synchronized void start() {
        if (this.fixedScheduler == null) {
            this.fixedScheduler = new ScheduledThreadPoolExecutor(1, new NamedThreadFactory("jboot-gateway-health-check"));
            this.fixedScheduler.scheduleWithFixedDelay(this, this.fixedSchedulerInitialDelay, this.fixedSchedulerDelay, TimeUnit.SECONDS);
        }
    }

    public void stop() {
        this.fixedScheduler.shutdown();
        this.fixedScheduler = null;
    }

    @Override
    public void run() {
        try {
            this.doHealthCheck();
        }
        catch (Exception ex) {
            LogKit.error((String)ex.toString(), (Throwable)ex);
        }
    }

    private void doHealthCheck() {
        for (JbootGatewayConfig config : JbootGatewayManager.me().getConfigMap().values()) {
            if (!config.isEnable() || !config.isUriHealthCheckEnable() || !StrUtil.isNotBlank(config.getUriHealthCheckPath())) continue;
            Set<String> uris = config.getUri();
            for (String uri : uris) {
                String url = uri + config.getUriHealthCheckPath();
                if (this.getHttpCode(url) == 200) {
                    config.removeUnHealthUri(uri);
                    continue;
                }
                config.addUnHealthUri(uri);
            }
        }
    }

    private int getHttpCode(String url) {
        try {
            JbootHttpRequest req = JbootHttpRequest.create(url);
            req.setReadBody(false);
            return HttpUtil.handle(req).getResponseCode();
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public ScheduledThreadPoolExecutor getFixedScheduler() {
        return this.fixedScheduler;
    }

    public long getFixedSchedulerInitialDelay() {
        return this.fixedSchedulerInitialDelay;
    }

    public void setFixedSchedulerInitialDelay(long fixedSchedulerInitialDelay) {
        this.fixedSchedulerInitialDelay = fixedSchedulerInitialDelay;
    }

    public long getFixedSchedulerDelay() {
        return this.fixedSchedulerDelay;
    }

    public void setFixedSchedulerDelay(long fixedSchedulerDelay) {
        this.fixedSchedulerDelay = fixedSchedulerDelay;
    }
}

