/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.gateway;

import io.jboot.components.gateway.GatewayInterceptor;
import io.jboot.components.gateway.GatewayLoadBalanceStrategy;
import io.jboot.core.spi.JbootSpiLoader;
import io.jboot.utils.ArrayUtil;
import io.jboot.utils.ClassUtil;
import io.jboot.utils.StrUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class JbootGatewayConfig
implements Serializable {
    public static final String DEFAULT_PROXY_CONTENT_TYPE = "text/html;charset=utf-8";
    public static final GatewayInterceptor[] EMPTY_GATEWAY_INTERCEPTOR_ARRAY = new GatewayInterceptor[0];
    private String name;
    private Set<String> uri;
    private boolean uriHealthCheckEnable;
    private String uriHealthCheckPath;
    private boolean enable = false;
    private boolean sentinelEnable = false;
    private String sentinelBlockPage;
    private Map<String, String> sentinelBlockJsonMap;
    private int proxyReadTimeout = 10000;
    private int proxyConnectTimeout = 5000;
    private int proxyRetries = 2;
    private String proxyContentType = "text/html;charset=utf-8";
    private String[] pathEquals;
    private String[] pathContains;
    private String[] pathStartsWith;
    private String[] pathEndsWith;
    private String[] hostEquals;
    private String[] hostContains;
    private String[] hostStartsWith;
    private String[] hostEndsWith;
    private Map<String, String> queryEquals;
    private String[] queryContains;
    private String[] interceptors;
    private String loadBalanceStrategy;
    private Set<String> unHealthUris = Collections.synchronizedSet(new HashSet());
    private Set<String> discoveryUris;
    private String[] healthUris;
    private boolean healthUriChanged = true;
    private GatewayInterceptor[] gatewayInterceptors;
    private GatewayLoadBalanceStrategy gatewayLoadBalanceStrategy;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<String> getUri() {
        return this.uri;
    }

    public void setUri(Set<String> uri) {
        this.uri = uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getHealthUris() {
        if (this.healthUriChanged) {
            JbootGatewayConfig jbootGatewayConfig = this;
            synchronized (jbootGatewayConfig) {
                if (this.healthUriChanged) {
                    if ((this.uri == null || this.uri.isEmpty()) && (this.discoveryUris == null || this.discoveryUris.isEmpty())) {
                        this.healthUris = null;
                    } else {
                        HashSet<String> healthUriSet = new HashSet<String>();
                        if (this.uri != null && !this.uri.isEmpty()) {
                            healthUriSet.addAll(this.uri);
                        }
                        if (this.discoveryUris != null && !this.discoveryUris.isEmpty()) {
                            healthUriSet.addAll(this.discoveryUris);
                        }
                        if (!this.unHealthUris.isEmpty()) {
                            healthUriSet.removeAll(this.unHealthUris);
                        }
                        this.healthUris = healthUriSet.isEmpty() ? null : healthUriSet.toArray(new String[healthUriSet.size()]);
                    }
                    this.healthUriChanged = false;
                }
            }
        }
        return this.healthUris;
    }

    public boolean isUriHealthCheckEnable() {
        return this.uriHealthCheckEnable;
    }

    public void setUriHealthCheckEnable(boolean uriHealthCheckEnable) {
        this.uriHealthCheckEnable = uriHealthCheckEnable;
    }

    public String getUriHealthCheckPath() {
        return this.uriHealthCheckPath;
    }

    public void setUriHealthCheckPath(String uriHealthCheckPath) {
        this.uriHealthCheckPath = uriHealthCheckPath;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public boolean isSentinelEnable() {
        return this.sentinelEnable;
    }

    public void setSentinelEnable(boolean sentinelEnable) {
        this.sentinelEnable = sentinelEnable;
    }

    public String getSentinelBlockPage() {
        return this.sentinelBlockPage;
    }

    public void setSentinelBlockPage(String sentinelBlockPage) {
        this.sentinelBlockPage = sentinelBlockPage;
    }

    public Map<String, String> getSentinelBlockJsonMap() {
        return this.sentinelBlockJsonMap;
    }

    public void setSentinelBlockJsonMap(Map<String, String> sentinelBlockJsonMap) {
        this.sentinelBlockJsonMap = sentinelBlockJsonMap;
    }

    public int getProxyReadTimeout() {
        return this.proxyReadTimeout;
    }

    public void setProxyReadTimeout(int proxyReadTimeout) {
        this.proxyReadTimeout = proxyReadTimeout;
    }

    public int getProxyConnectTimeout() {
        return this.proxyConnectTimeout;
    }

    public void setProxyConnectTimeout(int proxyConnectTimeout) {
        this.proxyConnectTimeout = proxyConnectTimeout;
    }

    public int getProxyRetries() {
        return this.proxyRetries;
    }

    public void setProxyRetries(int proxyRetries) {
        this.proxyRetries = proxyRetries;
    }

    public String getProxyContentType() {
        return this.proxyContentType;
    }

    public void setProxyContentType(String proxyContentType) {
        this.proxyContentType = proxyContentType;
    }

    public String[] getPathEquals() {
        return this.pathEquals;
    }

    public void setPathEquals(String[] pathEquals) {
        this.pathEquals = pathEquals;
    }

    public String[] getPathContains() {
        return this.pathContains;
    }

    public void setPathContains(String[] pathContains) {
        this.pathContains = pathContains;
    }

    public String[] getPathStartsWith() {
        return this.pathStartsWith;
    }

    public void setPathStartsWith(String[] pathStartsWith) {
        this.pathStartsWith = pathStartsWith;
    }

    public String[] getPathEndsWith() {
        return this.pathEndsWith;
    }

    public void setPathEndsWith(String[] pathEndsWith) {
        this.pathEndsWith = pathEndsWith;
    }

    public String[] getHostEquals() {
        return this.hostEquals;
    }

    public void setHostEquals(String[] hostEquals) {
        this.hostEquals = hostEquals;
    }

    public String[] getHostContains() {
        return this.hostContains;
    }

    public void setHostContains(String[] hostContains) {
        this.hostContains = hostContains;
    }

    public String[] getHostStartsWith() {
        return this.hostStartsWith;
    }

    public void setHostStartsWith(String[] hostStartsWith) {
        this.hostStartsWith = hostStartsWith;
    }

    public String[] getHostEndsWith() {
        return this.hostEndsWith;
    }

    public void setHostEndsWith(String[] hostEndsWith) {
        this.hostEndsWith = hostEndsWith;
    }

    public Map<String, String> getQueryEquals() {
        return this.queryEquals;
    }

    public void setQueryEquals(Map<String, String> queryEquals) {
        this.queryEquals = queryEquals;
    }

    public String[] getQueryContains() {
        return this.queryContains;
    }

    public void setQueryContains(String[] queryContains) {
        this.queryContains = queryContains;
    }

    public String[] getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(String[] interceptors) {
        this.interceptors = interceptors;
    }

    public GatewayInterceptor[] getGatewayInterceptors() {
        if (this.gatewayInterceptors == null) {
            if (this.interceptors == null || this.interceptors.length == 0) {
                this.gatewayInterceptors = EMPTY_GATEWAY_INTERCEPTOR_ARRAY;
            } else {
                this.gatewayInterceptors = new GatewayInterceptor[this.interceptors.length];
                for (int i = 0; i < this.interceptors.length; ++i) {
                    GatewayInterceptor interceptor = JbootSpiLoader.load(GatewayInterceptor.class, this.interceptors[i]);
                    if (interceptor == null) {
                        throw new NullPointerException("can not new instance by class:" + this.interceptors[i]);
                    }
                    this.gatewayInterceptors[i] = interceptor;
                }
            }
        }
        return this.gatewayInterceptors;
    }

    public void setGatewayInterceptors(GatewayInterceptor[] gatewayInterceptors) {
        this.gatewayInterceptors = gatewayInterceptors;
    }

    public String getLoadBalanceStrategy() {
        return this.loadBalanceStrategy;
    }

    public void setLoadBalanceStrategy(String loadBalanceStrategy) {
        this.loadBalanceStrategy = loadBalanceStrategy;
    }

    public GatewayLoadBalanceStrategy buildLoadBalanceStrategy() {
        if (this.gatewayLoadBalanceStrategy != null) {
            return this.gatewayLoadBalanceStrategy;
        }
        if (StrUtil.isBlank((String)this.loadBalanceStrategy)) {
            this.gatewayLoadBalanceStrategy = GatewayLoadBalanceStrategy.DEFAULT_STRATEGY;
        } else {
            GatewayLoadBalanceStrategy glbs = (GatewayLoadBalanceStrategy)ClassUtil.newInstance(this.loadBalanceStrategy);
            if (glbs == null) {
                throw new NullPointerException("Can not new instance by class: " + this.loadBalanceStrategy);
            }
            this.gatewayLoadBalanceStrategy = glbs;
        }
        return this.gatewayLoadBalanceStrategy;
    }

    public void setGatewayLoadBalanceStrategy(GatewayLoadBalanceStrategy strategy) {
        this.gatewayLoadBalanceStrategy = strategy;
    }

    public boolean matches(HttpServletRequest request) {
        Map<String, String> queryMap;
        if (request == null) {
            return false;
        }
        String path = request.getServletPath();
        if (this.pathEquals != null) {
            for (String p : this.pathEquals) {
                if (!path.equals(p)) continue;
                return true;
            }
        }
        if (this.pathContains != null) {
            for (String p : this.pathContains) {
                if (!path.contains(p)) continue;
                return true;
            }
        }
        if (this.pathStartsWith != null) {
            for (String p : this.pathStartsWith) {
                if (!path.startsWith(p)) continue;
                return true;
            }
        }
        if (this.pathEndsWith != null) {
            for (String p : this.pathEndsWith) {
                if (!path.endsWith(p)) continue;
                return true;
            }
        }
        String host = request.getServerName();
        if (this.hostEquals != null) {
            for (String h : this.hostEquals) {
                if (!host.equals(h)) continue;
                return true;
            }
        }
        if (this.hostContains != null) {
            for (String h : this.hostContains) {
                if (!host.contains(h)) continue;
                return true;
            }
        }
        if (this.hostStartsWith != null) {
            for (String h : this.hostStartsWith) {
                if (!host.startsWith(h)) continue;
                return true;
            }
        }
        if (this.hostEndsWith != null) {
            for (String h : this.hostEndsWith) {
                if (!host.endsWith(h)) continue;
                return true;
            }
        }
        if (!(this.queryContains == null && this.queryEquals == null || (queryMap = StrUtil.queryStringToMap(request.getQueryString())).isEmpty())) {
            if (this.queryContains != null) {
                for (String q : this.queryContains) {
                    if (!queryMap.containsKey(q)) continue;
                    return true;
                }
            }
            if (this.queryEquals != null) {
                for (Map.Entry<String, String> e : this.queryEquals.entrySet()) {
                    String queryValue = queryMap.get(e.getKey());
                    if (!Objects.equals(queryValue, e.getValue())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void syncDiscoveryUris(Collection<String> syncUris) {
        if (ArrayUtil.isSameElements(syncUris, this.discoveryUris)) {
            return;
        }
        if (syncUris == null || syncUris.isEmpty()) {
            this.discoveryUris = null;
            this.healthUriChanged = true;
            return;
        }
        if (this.discoveryUris == null) {
            this.discoveryUris = new HashSet<String>(syncUris);
            this.healthUriChanged = true;
        } else {
            this.discoveryUris.clear();
            this.discoveryUris.addAll(syncUris);
            this.healthUriChanged = true;
        }
    }

    public void addUnHealthUri(String uri) {
        if (this.unHealthUris.add(uri)) {
            this.healthUriChanged = true;
        }
    }

    public void removeUnHealthUri(String uri) {
        if (this.unHealthUris.size() > 0 && this.unHealthUris.remove(uri)) {
            this.healthUriChanged = true;
        }
    }
}

