/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.gateway;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.Tracer;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.jfinal.kit.LogKit;
import io.jboot.components.gateway.GatewayErrorRender;
import io.jboot.components.gateway.GatewayHttpProxy;
import io.jboot.components.gateway.JbootGatewayConfig;
import io.jboot.components.gateway.JbootGatewayManager;
import io.jboot.support.sentinel.SentinelUtil;
import io.jboot.utils.StrUtil;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GatewaySentinelProcesser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(GatewayHttpProxy proxy, String proxyUrl, JbootGatewayConfig config, HttpServletRequest req, HttpServletResponse resp, boolean skipExceptionRender) {
        Entry entry = null;
        String resourceName = SentinelUtil.buildResource(req);
        try {
            entry = SphU.entry((String)resourceName, (int)3, (EntryType)EntryType.IN);
            proxy.sendRequest(proxyUrl, req, resp);
        }
        catch (BlockException ex) {
            if (skipExceptionRender) {
                GatewayErrorRender errorRender = JbootGatewayManager.me().getGatewayErrorRender();
                if (errorRender != null) {
                    errorRender.renderError((Exception)((Object)ex), GatewayErrorRender.sentinelBlockedError, config, req, resp);
                } else {
                    this.processBlocked(config, req, resp);
                }
            } else {
                proxy.setException((Exception)((Object)ex));
            }
        }
        finally {
            if (proxy.getException() != null) {
                Tracer.traceEntry((Throwable)proxy.getException(), (Entry)entry);
            }
            if (entry != null) {
                entry.exit();
            }
        }
    }

    private void processBlocked(JbootGatewayConfig config, HttpServletRequest req, HttpServletResponse resp) {
        StringBuffer url = req.getRequestURL();
        if ("GET".equalsIgnoreCase(req.getMethod()) && StrUtil.isNotBlank(req.getQueryString())) {
            url.append("?").append(req.getQueryString());
        }
        try {
            if (StringUtil.isNotBlank((String)config.getSentinelBlockPage())) {
                String redirectUrl = config.getSentinelBlockPage() + "?http_referer=" + url.toString();
                resp.sendRedirect(redirectUrl);
            } else if (config.getSentinelBlockJsonMap() != null && !config.getSentinelBlockJsonMap().isEmpty()) {
                SentinelUtil.writeDefaultBlockedJson(resp, config.getSentinelBlockJsonMap());
            } else {
                SentinelUtil.writeDefaultBlockedPage(resp);
            }
        }
        catch (IOException ex) {
            LogKit.error((String)ex.toString(), (Throwable)ex);
        }
    }
}

