/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.gateway;

import com.jfinal.kit.Ret;
import io.jboot.Jboot;
import io.jboot.components.gateway.GatewayErrorRender;
import io.jboot.components.gateway.GatewayHttpProxy;
import io.jboot.components.gateway.GatewayInterceptor;
import io.jboot.components.gateway.GatewayLoadBalanceStrategy;
import io.jboot.components.gateway.GatewaySentinelProcesser;
import io.jboot.components.gateway.JbootGatewayConfig;
import io.jboot.components.gateway.JbootGatewayManager;
import io.jboot.utils.StrUtil;
import io.jboot.web.render.JbootJsonRender;
import java.net.ConnectException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GatewayInvocation {
    private JbootGatewayConfig config;
    private GatewayInterceptor[] inters;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private GatewayHttpProxy proxy;
    private String proxyUrl;
    private boolean skipExceptionRender = false;
    private static boolean devMode = Jboot.isDevMode();
    private int index = 0;

    public GatewayInvocation(JbootGatewayConfig config, HttpServletRequest request, HttpServletResponse response) {
        this.config = config;
        this.request = request;
        this.response = response;
        this.inters = config.getGatewayInterceptors();
        this.proxy = new GatewayHttpProxy(config);
        this.proxyUrl = GatewayInvocation.buildProxyUrl(config, request);
    }

    public void invoke() {
        if (this.inters.length == 0) {
            this.doInvoke();
            return;
        }
        if (this.index < this.inters.length) {
            this.inters[this.index++].intercept(this);
        } else if (this.index++ >= this.inters.length) {
            this.doInvoke();
        }
    }

    protected void doInvoke() {
        if (StrUtil.isBlank((String)this.proxyUrl)) {
            GatewayInvocation.renderError(null, GatewayErrorRender.noneHealthUrl, this.config, this.request, this.response);
            return;
        }
        if (devMode) {
            System.out.println("Jboot Gateway >>> " + this.proxyUrl);
        }
        if (this.config.isSentinelEnable()) {
            new GatewaySentinelProcesser().process(this.proxy, this.proxyUrl, this.config, this.request, this.response, this.skipExceptionRender);
        } else {
            this.proxy.sendRequest(this.proxyUrl, this.request, this.response);
            Exception exception = this.proxy.getException();
            if (exception != null && !this.skipExceptionRender) {
                if (exception instanceof ConnectException) {
                    Ret connectionError = Ret.fail().set((Object)"errorCode", (Object)2).set((Object)"message", (Object)("Can not connect to target server: " + this.proxyUrl));
                    GatewayInvocation.renderError(exception, connectionError, this.config, this.request, this.response);
                } else {
                    Ret ret = Ret.fail().set((Object)"errorCode", (Object)9).set((Object)"message", (Object)exception.getMessage());
                    GatewayInvocation.renderError(exception, ret, this.config, this.request, this.response);
                }
            }
        }
    }

    private static void renderError(Exception error, Ret errorMessage, JbootGatewayConfig config, HttpServletRequest request, HttpServletResponse response) {
        GatewayErrorRender errorRender = JbootGatewayManager.me().getGatewayErrorRender();
        if (errorRender != null) {
            errorRender.renderError(error, errorMessage, config, request, response);
        } else {
            new JbootJsonRender(errorMessage).setContext(request, response).render();
        }
    }

    private static String buildProxyUrl(JbootGatewayConfig config, HttpServletRequest request) {
        GatewayLoadBalanceStrategy lbs = config.buildLoadBalanceStrategy();
        String url = lbs.getUrl(config, request);
        if (StrUtil.isBlank((String)url)) {
            return null;
        }
        StringBuilder sb = new StringBuilder(url);
        if (StrUtil.isNotBlank(request.getRequestURI())) {
            sb.append(request.getRequestURI());
        }
        if (StrUtil.isNotBlank(request.getQueryString())) {
            sb.append("?").append(request.getQueryString());
        }
        return sb.toString();
    }

    public JbootGatewayConfig getConfig() {
        return this.config;
    }

    public void setConfig(JbootGatewayConfig config) {
        this.config = config;
    }

    public GatewayInterceptor[] getInters() {
        return this.inters;
    }

    public void setInters(GatewayInterceptor[] inters) {
        this.inters = inters;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public GatewayHttpProxy getProxy() {
        return this.proxy;
    }

    public void setProxy(GatewayHttpProxy proxy) {
        this.proxy = proxy;
    }

    public boolean hasException() {
        return this.proxy.getException() != null;
    }

    public String getProxyUrl() {
        return this.proxyUrl;
    }

    public void setProxyUrl(String proxyUrl) {
        this.proxyUrl = proxyUrl;
    }

    public boolean isSkipExceptionRender() {
        return this.skipExceptionRender;
    }

    public void setSkipExceptionRender(boolean skipExceptionRender) {
        this.skipExceptionRender = skipExceptionRender;
    }
}

