/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.gateway;

import com.jfinal.kit.LogKit;
import com.jfinal.log.Log;
import io.jboot.components.gateway.JbootGatewayConfig;
import io.jboot.exception.JbootException;
import io.jboot.utils.StrUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GatewayHttpProxy {
    private static final Log LOG = Log.getLog(GatewayHttpProxy.class);
    private int readTimeOut = 10000;
    private int connectTimeOut = 5000;
    private int retries = 2;
    private String contentType = "text/html;charset=utf-8";
    private boolean instanceFollowRedirects = false;
    private boolean useCaches = false;
    private Map<String, String> headers;
    private Exception exception;
    protected static X509TrustManager trustAnyTrustManager = new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    };
    protected static HostnameVerifier hnv = (hostname, session) -> true;

    public GatewayHttpProxy() {
    }

    public GatewayHttpProxy(JbootGatewayConfig config) {
        this.readTimeOut = config.getProxyReadTimeout();
        this.connectTimeOut = config.getProxyConnectTimeout();
        this.retries = config.getProxyRetries();
        this.contentType = config.getProxyContentType();
    }

    public void sendRequest(String url, HttpServletRequest req, HttpServletResponse resp) {
        int triesCount = Math.max(this.retries, 0);
        Exception exception = null;
        do {
            try {
                exception = null;
                this.doSendRequest(url, req, resp);
            }
            catch (Exception ex) {
                exception = ex;
            }
        } while (exception != null && triesCount-- > 0);
        if (exception != null) {
            this.exception = exception;
            LOG.error(exception.toString(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSendRequest(String url, HttpServletRequest req, HttpServletResponse resp) throws Exception {
        HttpURLConnection conn = null;
        try {
            conn = this.getConnection(url);
            this.configConnection(conn, req);
            if ("get".equalsIgnoreCase(req.getMethod())) {
                conn.connect();
            } else {
                conn.setDoOutput(true);
                conn.setDoInput(true);
                this.copyRequestStreamToConnection(req, conn);
            }
            this.configResponse(resp, conn);
            this.copyConnStreamToResponse(conn, resp);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyRequestStreamToConnection(HttpServletRequest req, HttpURLConnection conn) throws IOException {
        OutputStream outStream = null;
        ServletInputStream inStream = null;
        try {
            int len;
            outStream = conn.getOutputStream();
            inStream = req.getInputStream();
            byte[] buffer = new byte[1024];
            while ((len = inStream.read(buffer)) != -1) {
                outStream.write(buffer, 0, len);
            }
        }
        catch (Throwable throwable) {
            this.quetlyClose(new Closeable[]{outStream, inStream});
            throw throwable;
        }
        this.quetlyClose(new Closeable[]{outStream, inStream});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyConnStreamToResponse(HttpURLConnection conn, HttpServletResponse resp) throws IOException {
        if (resp.isCommitted()) {
            return;
        }
        InputStream inStream = null;
        ServletOutputStream outStream = null;
        try {
            int len;
            inStream = this.getInputStream(conn);
            outStream = resp.getOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = inStream.read(buffer)) != -1) {
                outStream.write(buffer, 0, len);
            }
        }
        catch (Throwable throwable) {
            this.quetlyClose(inStream);
            throw throwable;
        }
        this.quetlyClose(inStream);
    }

    protected void quetlyClose(Closeable ... closeables) {
        for (Closeable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (IOException e) {
                LogKit.logNothing((Throwable)e);
            }
        }
    }

    protected void configResponse(HttpServletResponse resp, HttpURLConnection conn) throws IOException {
        if (resp.isCommitted()) {
            return;
        }
        resp.setStatus(conn.getResponseCode());
        boolean isContentTypeSetted = false;
        Map<String, List<String>> headerFields = conn.getHeaderFields();
        if (headerFields != null && !headerFields.isEmpty()) {
            Set<String> headerNames = headerFields.keySet();
            for (String headerName : headerNames) {
                String headerFieldValue;
                if (StrUtil.isBlank((String)headerName) || "Content-Encoding".equalsIgnoreCase(headerName) || !StrUtil.isNotBlank(headerFieldValue = conn.getHeaderField(headerName))) continue;
                resp.setHeader(headerName, headerFieldValue);
                if (!"Content-Type".equalsIgnoreCase(headerName)) continue;
                isContentTypeSetted = true;
            }
        }
        if (!isContentTypeSetted) {
            resp.setContentType(this.contentType);
        }
    }

    protected InputStream getInputStream(HttpURLConnection conn) throws IOException {
        InputStream stream;
        InputStream inputStream = stream = conn.getResponseCode() >= 400 ? conn.getErrorStream() : conn.getInputStream();
        if ("gzip".equalsIgnoreCase(conn.getContentEncoding())) {
            return new GZIPInputStream(stream);
        }
        return stream;
    }

    protected void configConnection(HttpURLConnection conn, HttpServletRequest req) throws ProtocolException {
        conn.setReadTimeout(this.readTimeOut);
        conn.setConnectTimeout(this.connectTimeOut);
        conn.setInstanceFollowRedirects(this.instanceFollowRedirects);
        conn.setUseCaches(this.useCaches);
        conn.setRequestMethod(req.getMethod());
        Enumeration headerNames = req.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerFieldValue;
            String headerName = (String)headerNames.nextElement();
            if (!StrUtil.isNotBlank(headerName) || !StrUtil.isNotBlank(headerFieldValue = req.getHeader(headerName))) continue;
            conn.setRequestProperty(headerName, headerFieldValue);
        }
        if (this.headers != null) {
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
    }

    protected HttpURLConnection getConnection(String urlString) {
        try {
            if (urlString.toLowerCase().startsWith("https")) {
                return this.getHttpsConnection(urlString);
            }
            return this.getHttpConnection(urlString);
        }
        catch (Throwable ex) {
            throw new JbootException(ex);
        }
    }

    protected HttpURLConnection getHttpConnection(String urlString) throws Exception {
        URL url = new URL(urlString);
        return (HttpURLConnection)url.openConnection();
    }

    protected HttpsURLConnection getHttpsConnection(String urlString) throws Exception {
        SSLContext sslContext = SSLContext.getInstance("SSL", "SunJSSE");
        TrustManager[] tm = new TrustManager[]{trustAnyTrustManager};
        sslContext.init(null, tm, null);
        SSLSocketFactory ssf = sslContext.getSocketFactory();
        URL url = new URL(urlString);
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        conn.setHostnameVerifier(hnv);
        conn.setSSLSocketFactory(ssf);
        return conn;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public int getReadTimeOut() {
        return this.readTimeOut;
    }

    public void setReadTimeOut(int readTimeOut) {
        this.readTimeOut = readTimeOut;
    }

    public int getConnectTimeOut() {
        return this.connectTimeOut;
    }

    public void setConnectTimeOut(int connectTimeOut) {
        this.connectTimeOut = connectTimeOut;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public boolean isInstanceFollowRedirects() {
        return this.instanceFollowRedirects;
    }

    public void setInstanceFollowRedirects(boolean instanceFollowRedirects) {
        this.instanceFollowRedirects = instanceFollowRedirects;
    }

    public boolean isUseCaches() {
        return this.useCaches;
    }

    public void setUseCaches(boolean useCaches) {
        this.useCaches = useCaches;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public GatewayHttpProxy addHeader(String key, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(key, value);
        return this;
    }

    public GatewayHttpProxy addHeaders(Map<String, String> headers) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.putAll(headers);
        return this;
    }
}

