/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.cache.redis;

import com.jfinal.plugin.ehcache.IDataLoader;
import io.jboot.Jboot;
import io.jboot.components.cache.JbootCacheBase;
import io.jboot.components.cache.JbootCacheConfig;
import io.jboot.components.cache.redis.JbootRedisCacheConfig;
import io.jboot.exception.JbootIllegalConfigException;
import io.jboot.support.redis.JbootRedis;
import io.jboot.support.redis.JbootRedisManager;
import io.jboot.support.redis.RedisScanResult;
import io.jboot.utils.StrUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class JbootRedisCacheImpl
extends JbootCacheBase {
    private JbootRedis redis;
    private JbootRedisCacheConfig cacheConfig = Jboot.config(JbootRedisCacheConfig.class);
    private String redisCacheNamesKey = "jboot_cache_names";
    private String globalKeyPrefix = "";

    public JbootRedisCacheImpl(JbootCacheConfig config) {
        super(config);
        if (StrUtil.isNotBlank(this.cacheConfig.getGlobalKeyPrefix())) {
            this.globalKeyPrefix = this.cacheConfig.getGlobalKeyPrefix() + ":";
            this.redisCacheNamesKey = this.globalKeyPrefix + this.redisCacheNamesKey;
        }
        this.redis = this.cacheConfig.isConfigOk() ? JbootRedisManager.me().getRedis(this.cacheConfig) : Jboot.getRedis();
        if (this.redis == null) {
            throw new JbootIllegalConfigException("can not get redis, please check your jboot.properties , please correct config jboot.cache.redis.host or jboot.redis.host ");
        }
    }

    @Override
    public <T> T get(String cacheName, Object key) {
        return this.redis.get(this.buildKey(cacheName, key));
    }

    @Override
    public void put(String cacheName, Object key, Object value) {
        if (value == null) {
            this.remove(cacheName, key);
            return;
        }
        this.redis.set(this.buildKey(cacheName, key), value);
        this.redis.sadd(this.buildCacheName(this.redisCacheNamesKey), cacheName);
    }

    @Override
    public void put(String cacheName, Object key, Object value, int liveSeconds) {
        if (value == null) {
            this.remove(cacheName, key);
            return;
        }
        if (liveSeconds <= 0) {
            this.put(cacheName, key, value);
            return;
        }
        this.redis.setex(this.buildKey(cacheName, key), liveSeconds, value);
        this.redis.sadd(this.buildCacheName(this.redisCacheNamesKey), cacheName);
    }

    @Override
    public void remove(String cacheName, Object key) {
        this.redis.del((Object)this.buildKey(cacheName, key));
    }

    @Override
    public void removeAll(String cacheName) {
        String cursor = "0";
        int scanCount = 1000;
        boolean continueState = true;
        do {
            RedisScanResult<String> redisScanResult = this.redis.scan(this.buildCacheName(cacheName) + ":*", cursor, scanCount);
            List<String> scanKeys = redisScanResult.getResults();
            cursor = redisScanResult.getCursor();
            if (scanKeys != null && scanKeys.size() > 0) {
                this.redis.del(scanKeys.toArray(new String[scanKeys.size()]));
            }
            if (!redisScanResult.isCompleteIteration()) continue;
            continueState = false;
        } while (continueState);
        this.redis.srem(this.buildCacheName(this.redisCacheNamesKey), cacheName);
    }

    @Override
    public <T> T get(String cacheName, Object key, IDataLoader dataLoader) {
        Object data = this.get(cacheName, key);
        if (data == null) {
            data = dataLoader.load();
            this.put(cacheName, key, data);
        }
        return data;
    }

    private String buildKey(String cacheName, Object key) {
        cacheName = this.buildCacheName(cacheName);
        StringBuilder keyBuilder = new StringBuilder(this.globalKeyPrefix).append(cacheName).append(":");
        if (key instanceof String) {
            keyBuilder.append("S");
        } else if (key instanceof Number) {
            keyBuilder.append("I");
        } else if (key == null) {
            keyBuilder.append("S");
            key = "null";
        } else {
            keyBuilder.append("O");
        }
        return keyBuilder.append(":").append(key).toString();
    }

    @Override
    public <T> T get(String cacheName, Object key, IDataLoader dataLoader, int liveSeconds) {
        if (liveSeconds <= 0) {
            return this.get(cacheName, key, dataLoader);
        }
        Object data = this.get(cacheName, key);
        if (data == null) {
            data = dataLoader.load();
            this.put(cacheName, key, data, liveSeconds);
        }
        return data;
    }

    @Override
    public Integer getTtl(String cacheName, Object key) {
        Long ttl = this.redis.ttl(this.buildKey(cacheName, key));
        return ttl != null ? Integer.valueOf(ttl.intValue()) : null;
    }

    @Override
    public void setTtl(String cacheName, Object key, int seconds) {
        this.redis.expire(this.buildKey(cacheName, key), seconds);
    }

    @Override
    public List getNames() {
        Set set = this.redis.smembers(this.buildCacheName(this.redisCacheNamesKey));
        return set == null ? null : new ArrayList(set);
    }

    @Override
    public List getKeys(String cacheName) {
        cacheName = this.buildCacheName(cacheName);
        ArrayList<String> keys = new ArrayList<String>();
        String cursor = "0";
        int scanCount = 1000;
        boolean continueState = true;
        do {
            RedisScanResult<String> redisScanResult = this.redis.scan(cacheName + ":*", cursor, scanCount);
            List<String> scanKeys = redisScanResult.getResults();
            cursor = redisScanResult.getCursor();
            if (scanKeys != null && scanKeys.size() > 0) {
                for (String key : scanKeys) {
                    keys.add(key.substring(cacheName.length() + 3));
                }
            }
            if (!redisScanResult.isCompleteIteration()) continue;
            continueState = false;
        } while (continueState);
        return keys;
    }

    public JbootRedis getRedis() {
        return this.redis;
    }
}

