/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.cache.j2cache;

import com.jfinal.log.Log;
import com.jfinal.plugin.ehcache.IDataLoader;
import io.jboot.components.cache.JbootCacheBase;
import io.jboot.components.cache.JbootCacheConfig;
import io.jboot.exception.JbootException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.oschina.j2cache.CacheChannel;
import net.oschina.j2cache.CacheObject;
import net.oschina.j2cache.J2Cache;

public class J2cacheImpl
extends JbootCacheBase {
    private static final Log LOG = Log.getLog(J2cacheImpl.class);
    private Method sendEvictCmdMethod;
    private Method sendClearCmdMethod;

    public J2cacheImpl(JbootCacheConfig config) {
        super(config);
    }

    @Override
    public <T> T get(String cacheName, Object key) {
        cacheName = this.buildCacheName(cacheName);
        CacheObject cacheObject = J2Cache.getChannel().get(cacheName, key.toString(), new boolean[]{false});
        return (T)(cacheObject != null ? cacheObject.getValue() : null);
    }

    @Override
    public void put(String cacheName, Object key, Object value) {
        cacheName = this.buildCacheName(cacheName);
        J2Cache.getChannel().set(cacheName, key.toString(), value);
    }

    @Override
    public void put(String cacheName, Object key, Object value, int liveSeconds) {
        cacheName = this.buildCacheName(cacheName);
        J2Cache.getChannel().set(cacheName, key.toString(), value, (long)liveSeconds);
    }

    @Override
    public void remove(String cacheName, Object key) {
        cacheName = this.buildCacheName(cacheName);
        J2Cache.getChannel().evict(cacheName, new String[]{key.toString()});
    }

    @Override
    public void removeAll(String cacheName) {
        cacheName = this.buildCacheName(cacheName);
        J2Cache.getChannel().clear(cacheName);
    }

    @Override
    public <T> T get(String cacheName, Object key, IDataLoader dataLoader) {
        Object value = this.get(cacheName, key);
        if (value == null && (value = dataLoader.load()) != null) {
            this.put(cacheName, key, value);
        }
        return value;
    }

    @Override
    public <T> T get(String cacheName, Object key, IDataLoader dataLoader, int liveSeconds) {
        if (liveSeconds <= 0) {
            return this.get(cacheName, key, dataLoader);
        }
        Object data = this.get(cacheName, key);
        if (data == null) {
            data = dataLoader.load();
            this.put(cacheName, key, data, liveSeconds);
        }
        return data;
    }

    @Override
    public synchronized void refresh(String cacheName, Object key) {
        cacheName = this.buildCacheName(cacheName);
        if (this.sendEvictCmdMethod == null) {
            this.sendEvictCmdMethod = this.getSendEvictCmdMethod();
        }
        try {
            if (this.sendEvictCmdMethod != null) {
                this.sendEvictCmdMethod.invoke((Object)J2Cache.getChannel(), cacheName, key);
            }
        }
        catch (Exception e) {
            LOG.error("refresh error!", (Throwable)e);
        }
    }

    @Override
    public synchronized void refresh(String cacheName) {
        cacheName = this.buildCacheName(cacheName);
        if (this.sendClearCmdMethod == null) {
            this.sendClearCmdMethod = this.getSendClearCmdMethod();
        }
        try {
            if (this.sendClearCmdMethod != null) {
                this.sendClearCmdMethod.invoke((Object)J2Cache.getChannel(), cacheName);
            }
        }
        catch (Exception e) {
            LOG.error("refresh error!", (Throwable)e);
        }
    }

    @Override
    public List getNames() {
        Collection regions = J2Cache.getChannel().getL1Provider().regions();
        return regions != null && !regions.isEmpty() ? regions.stream().map(CacheChannel.Region::getName).collect(Collectors.toList()) : null;
    }

    @Override
    public List getKeys(String cacheName) {
        cacheName = this.buildCacheName(cacheName);
        Collection keys = J2Cache.getChannel().keys(cacheName);
        return keys != null ? new ArrayList(keys) : null;
    }

    private Method getSendEvictCmdMethod() {
        try {
            Method method = CacheChannel.class.getDeclaredMethod("sendEvictCmd", String.class, String[].class);
            method.setAccessible(true);
            return method;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Method getSendClearCmdMethod() {
        try {
            Method method = CacheChannel.class.getDeclaredMethod("sendClearCmd", String.class);
            method.setAccessible(true);
            return method;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Integer getTtl(String cacheName, Object key) {
        throw new JbootException("getTtl not support in j2cache");
    }

    @Override
    public void setTtl(String cacheName, Object key, int seconds) {
        throw new JbootException("setTtl not support in j2cache");
    }
}

