/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.cache.interceptor;

import com.jfinal.template.Engine;
import io.jboot.components.cache.ActionCache;
import io.jboot.components.cache.AopCache;
import io.jboot.components.cache.annotation.CacheEvict;
import io.jboot.components.cache.interceptor.ParaDirective;
import io.jboot.db.model.Columns;
import io.jboot.exception.JbootException;
import io.jboot.utils.AnnotationUtil;
import io.jboot.utils.ArrayUtil;
import io.jboot.utils.ClassUtil;
import io.jboot.utils.DateUtil;
import io.jboot.utils.StrUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collection;
import java.util.HashMap;

class Utils {
    static final Engine ENGINE = new Engine("JbootCacheRenderEngine");

    Utils() {
    }

    static String engineRender(String template, Method method, Object[] arguments) {
        HashMap<String, Object> datas = new HashMap<String, Object>();
        int x = 0;
        for (Parameter p : method.getParameters()) {
            if (!p.isNamePresent()) {
                throw new RuntimeException(" Maven or IDE config is error. see https://jfinal.com/doc/3-3 ");
            }
            datas.put(p.getName(), arguments[x++]);
        }
        return ENGINE.getTemplateByString(template).renderToString(datas);
    }

    static String buildCacheKey(String key, Class<?> clazz, Method method, Object[] arguments) {
        clazz = ClassUtil.getUsefulClass(clazz);
        if (StrUtil.isNotBlank(key)) {
            return Utils.renderKey(key, method, arguments);
        }
        StringBuilder keyBuilder = new StringBuilder(clazz.getSimpleName());
        keyBuilder.append('.').append(method.getName());
        if (ArrayUtil.isNullOrEmpty(arguments)) {
            return keyBuilder.append("()").toString();
        }
        Class<?>[] paramTypes = method.getParameterTypes();
        int index = 0;
        for (Object argument : arguments) {
            String argString = Utils.convertToString(argument, method);
            if (index == 0) {
                keyBuilder.append("(");
            } else {
                keyBuilder.append(", ");
            }
            keyBuilder.append(paramTypes[index++].getSimpleName()).append(':').append(argString);
            if (index != arguments.length) continue;
            keyBuilder.append(")");
        }
        return keyBuilder.toString();
    }

    private static String renderKey(String key, Method method, Object[] arguments) {
        int indexOfEndFlag;
        int indexOfStartFlag = key.indexOf("#");
        if (indexOfStartFlag > -1 && (indexOfEndFlag = key.indexOf(")")) > indexOfStartFlag) {
            return Utils.engineRender(key, method, arguments);
        }
        return key;
    }

    public static void ensureCacheNameNotBlank(Method method, String cacheName) {
        if (StrUtil.isBlank((String)cacheName)) {
            throw new JbootException(String.format("Cache name must not empty or blank in method: " + ClassUtil.buildMethodString(method), new Object[0]));
        }
    }

    static boolean isSupportClass(Class<?> clazz) {
        return clazz == String.class || clazz == Integer.class || clazz == Integer.TYPE || clazz == Short.class || clazz == Short.TYPE || clazz == Long.class || clazz == Long.TYPE || clazz == Double.class || clazz == Double.TYPE || clazz == Float.class || clazz == Float.TYPE || clazz == Boolean.class || clazz == Boolean.TYPE || clazz == Character.TYPE || clazz == BigDecimal.class || clazz == BigInteger.class || clazz == java.util.Date.class || clazz == Date.class || clazz == Timestamp.class || clazz == Time.class || clazz == LocalDate.class || clazz == LocalDateTime.class || clazz == LocalTime.class || clazz.isArray() || clazz.isAssignableFrom(Collection.class) || clazz == Columns.class;
    }

    static String convertToString(Object object, Method method) {
        if (object == null) {
            return "null";
        }
        if (!Utils.isSupportClass(object.getClass())) {
            String msg = "Unsupported empty key for annotation @Cacheable, @CacheEvict or @CachePut at method[" + ClassUtil.buildMethodString(method) + "], Please config key properties in the annotation.";
            throw new IllegalArgumentException(msg);
        }
        if (object.getClass().isArray()) {
            StringBuilder ret = new StringBuilder();
            Object[] values = (Object[])object;
            int index = 0;
            for (Object value : values) {
                if (index == 0) {
                    ret.append('[');
                }
                ret.append(Utils.convertToString(value, method));
                if (++index != values.length) {
                    ret.append(',');
                    continue;
                }
                ret.append(']');
            }
            return ret.toString();
        }
        if (object instanceof Collection) {
            Collection c = (Collection)object;
            StringBuilder ret = new StringBuilder();
            int index = 0;
            for (Object o : c) {
                if (index == 0) {
                    ret.append('[');
                }
                ret.append(Utils.convertToString(o, method));
                if (++index != c.size()) {
                    ret.append(',');
                    continue;
                }
                ret.append(']');
            }
            return ret.toString();
        }
        if (object instanceof java.util.Date) {
            return String.valueOf(((java.util.Date)object).getTime());
        }
        if (object instanceof LocalDateTime) {
            return String.valueOf(DateUtil.toDate((LocalDateTime)object).getTime());
        }
        if (object instanceof LocalDate) {
            return String.valueOf(DateUtil.toDate((LocalDate)object).getTime());
        }
        if (object instanceof LocalTime) {
            return String.valueOf(DateUtil.toDate((LocalTime)object).getTime());
        }
        if (object instanceof Columns) {
            return ((Columns)object).getCacheKey();
        }
        return String.valueOf(object);
    }

    static boolean isUnless(String unlessString, Method method, Object[] arguments) {
        if (StrUtil.isBlank((String)unlessString)) {
            return false;
        }
        unlessString = "#(" + unlessString + ")";
        return "true".equals(Utils.engineRender(unlessString, method, arguments));
    }

    static void removeCache(Object[] arguments, Class<?> targetClass, Method method, CacheEvict evict, boolean isAction) {
        String unless = AnnotationUtil.get(evict.unless());
        if (Utils.isUnless(unless, method, arguments)) {
            return;
        }
        String cacheName = AnnotationUtil.get(evict.name());
        if (StrUtil.isBlank((String)cacheName)) {
            throw new JbootException(String.format("CacheEvict.name()  must not empty in method [%s].", ClassUtil.buildMethodString(method)));
        }
        String cacheKey = AnnotationUtil.get(evict.key());
        if (StrUtil.isBlank((String)cacheKey) || "*".equals(cacheKey.trim())) {
            if (isAction) {
                ActionCache.removeAll(cacheName);
            } else {
                AopCache.removeAll(cacheName);
            }
        } else {
            cacheKey = Utils.buildCacheKey(cacheKey, targetClass, method, arguments);
            if (isAction) {
                ActionCache.remove(cacheName, cacheKey);
            } else {
                AopCache.remove(cacheName, cacheKey);
            }
        }
    }

    static {
        ENGINE.addDirective("para", ParaDirective.class);
        ENGINE.addSharedStaticMethod(ParaDirective.class);
    }
}

