/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.cache.interceptor;

import com.jfinal.core.Controller;
import com.jfinal.kit.LogKit;
import com.jfinal.template.Env;
import com.jfinal.template.io.Writer;
import com.jfinal.template.stat.Scope;
import io.jboot.utils.StrUtil;
import io.jboot.web.controller.JbootControllerContext;
import io.jboot.web.directive.base.JbootDirectiveBase;
import java.io.IOException;

public class ParaDirective
extends JbootDirectiveBase {
    @Override
    public void onRender(Env env, Scope scope, Writer writer) {
        Controller controller = JbootControllerContext.get();
        if (controller == null) {
            throw new IllegalStateException("#para(...) directive only use for controller." + this.getLocation());
        }
        String key = (String)this.getPara(0, scope);
        String defaultValue = (String)this.getPara(1, scope);
        if (StrUtil.isBlank((String)key)) {
            throw new IllegalArgumentException("#para(...) argument must not be empty." + this.getLocation());
        }
        String value = controller.getPara(key);
        if (StrUtil.isBlank((String)value)) {
            value = StrUtil.isNotBlank(defaultValue) ? defaultValue : "";
        }
        try {
            writer.write(value);
        }
        catch (IOException e) {
            LogKit.error((String)e.toString(), (Throwable)e);
        }
    }

    public static Object para(String key) {
        return ParaDirective.para(key, null);
    }

    public static Object para(String key, Object defaultValue) {
        Controller controller = JbootControllerContext.get();
        if (controller == null) {
            throw new IllegalStateException("para(...) method only use for controller.");
        }
        String value = controller.get(key);
        if (StrUtil.isNumeric(value)) {
            return Long.valueOf(value);
        }
        if (StrUtil.isDecimal(value)) {
            return Double.parseDouble(value);
        }
        return StrUtil.isNotBlank(value) ? value : defaultValue;
    }
}

