/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.cache.interceptor;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import com.jfinal.log.Log;
import io.jboot.components.cache.annotation.CacheEvict;
import io.jboot.components.cache.annotation.CachesEvict;
import io.jboot.components.cache.interceptor.Utils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class CachesEvictInterceptor
implements Interceptor {
    private static final Log LOG = Log.getLog(CachesEvictInterceptor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void intercept(Invocation inv) {
        Method method = inv.getMethod();
        CachesEvict cachesEvict = method.getAnnotation(CachesEvict.class);
        if (cachesEvict == null) {
            inv.invoke();
            return;
        }
        CacheEvict[] evicts = cachesEvict.value();
        ArrayList<CacheEvict> beforeInvocations = null;
        ArrayList<CacheEvict> afterInvocations = null;
        for (CacheEvict evict : evicts) {
            if (evict.beforeInvocation()) {
                if (beforeInvocations == null) {
                    beforeInvocations = new ArrayList<CacheEvict>();
                }
                beforeInvocations.add(evict);
                continue;
            }
            if (afterInvocations == null) {
                afterInvocations = new ArrayList<CacheEvict>();
            }
            afterInvocations.add(evict);
        }
        Class<?> targetClass = inv.getTarget().getClass();
        try {
            this.doCachesEvict(inv.getArgs(), targetClass, method, beforeInvocations, inv.isActionInvocation());
            inv.invoke();
        }
        finally {
            this.doCachesEvict(inv.getArgs(), targetClass, method, afterInvocations, inv.isActionInvocation());
        }
    }

    private void doCachesEvict(Object[] arguments, Class<?> targetClass, Method method, List<CacheEvict> cacheEvicts, boolean isAction) {
        if (cacheEvicts == null || cacheEvicts.isEmpty()) {
            return;
        }
        for (CacheEvict evict : cacheEvicts) {
            try {
                Utils.removeCache(arguments, targetClass, method, evict, isAction);
            }
            catch (Exception ex) {
                LOG.error(ex.toString(), (Throwable)ex);
            }
        }
    }
}

