/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.cache.interceptor;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import com.jfinal.core.Action;
import com.jfinal.core.CPI;
import com.jfinal.core.Controller;
import com.jfinal.plugin.activerecord.Page;
import io.jboot.components.cache.ActionCache;
import io.jboot.components.cache.AopCache;
import io.jboot.components.cache.annotation.Cacheable;
import io.jboot.components.cache.interceptor.Utils;
import io.jboot.db.model.JbootModel;
import io.jboot.exception.JbootException;
import io.jboot.utils.AnnotationUtil;
import io.jboot.utils.ClassUtil;
import io.jboot.utils.ModelUtil;
import io.jboot.web.cached.CacheSupportResponseProxy;
import io.jboot.web.cached.CachedContent;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CacheableInterceptor
implements Interceptor {
    private static final String NULL_VALUE = "NULL_VALUE";
    private static boolean actionCacheEnable = true;

    public static boolean isActionCacheEnable() {
        return actionCacheEnable;
    }

    public static void setActionCacheEnable(boolean actionCacheEnable) {
        CacheableInterceptor.actionCacheEnable = actionCacheEnable;
    }

    public void intercept(Invocation inv) {
        Method method = inv.getMethod();
        Cacheable cacheable = method.getAnnotation(Cacheable.class);
        if (cacheable == null || inv.isActionInvocation() && !actionCacheEnable) {
            inv.invoke();
            return;
        }
        if (inv.isActionInvocation()) {
            this.forController(inv, method, cacheable);
        } else {
            this.forService(inv, method, cacheable);
        }
    }

    private void forController(Invocation inv, Method method, Cacheable cacheable) {
        String unlessString = AnnotationUtil.get(cacheable.unless());
        if (Utils.isUnless(unlessString, method, inv.getArgs())) {
            inv.invoke();
            return;
        }
        Class<?> targetClass = inv.getTarget().getClass();
        String cacheName = AnnotationUtil.get(cacheable.name());
        Utils.ensureCacheNameNotBlank(method, cacheName);
        String cacheKey = Utils.buildCacheKey(AnnotationUtil.get(cacheable.key()), targetClass, method, inv.getArgs());
        Controller controller = inv.getController();
        CachedContent cachedContent = (CachedContent)ActionCache.get(cacheName, cacheKey);
        if (cachedContent != null) {
            this.writeCachedContent(controller, cachedContent);
            return;
        }
        CacheSupportResponseProxy responseProxy = new CacheSupportResponseProxy(controller.getResponse());
        responseProxy.setCacheName(cacheName);
        responseProxy.setCacheKey(cacheKey);
        responseProxy.setCacheLiveSeconds(cacheable.liveSeconds());
        CPI._init_((Controller)controller, (Action)CPI.getAction((Controller)controller), (HttpServletRequest)controller.getRequest(), (HttpServletResponse)responseProxy, (String)controller.getPara());
        inv.invoke();
    }

    private void writeCachedContent(Controller controller, CachedContent cachedContent) {
        HttpServletResponse response = controller.getResponse();
        Map<String, String> headers = cachedContent.getHeaders();
        if (headers != null && !headers.isEmpty()) {
            headers.forEach((arg_0, arg_1) -> ((HttpServletResponse)response).addHeader(arg_0, arg_1));
        }
        controller.render(cachedContent.createRender());
    }

    private void forService(Invocation inv, Method method, Cacheable cacheable) {
        String unlessString = AnnotationUtil.get(cacheable.unless());
        if (Utils.isUnless(unlessString, method, inv.getArgs())) {
            inv.invoke();
            return;
        }
        Class<?> targetClass = inv.getTarget().getClass();
        String cacheName = AnnotationUtil.get(cacheable.name());
        Utils.ensureCacheNameNotBlank(method, cacheName);
        String cacheKey = Utils.buildCacheKey(AnnotationUtil.get(cacheable.key()), targetClass, method, inv.getArgs());
        Object data = AopCache.get(cacheName, cacheKey);
        if (data != null) {
            if (NULL_VALUE.equals(data)) {
                inv.setReturnValue(null);
            } else if (cacheable.returnCopyEnable()) {
                inv.setReturnValue(this.getCopyObject(inv, data));
            } else {
                inv.setReturnValue(data);
            }
        } else {
            inv.invoke();
            data = inv.getReturnValue();
            if (data != null) {
                AopCache.putDataToCache(cacheName, cacheKey, data, cacheable.liveSeconds());
                if (cacheable.returnCopyEnable()) {
                    inv.setReturnValue(this.getCopyObject(inv, data));
                }
            } else if (cacheable.nullCacheEnable()) {
                AopCache.putDataToCache(cacheName, cacheKey, NULL_VALUE, cacheable.liveSeconds());
            }
        }
    }

    private <M extends JbootModel> Object getCopyObject(Invocation inv, Object data) {
        if (data instanceof List) {
            return ModelUtil.copy((List)data);
        }
        if (data instanceof Set) {
            return ModelUtil.copy((Set)data);
        }
        if (data instanceof Page) {
            return ModelUtil.copy((Page)data);
        }
        if (data instanceof JbootModel) {
            return ModelUtil.copy((JbootModel)((Object)data));
        }
        if (data.getClass().isArray() && JbootModel.class.isAssignableFrom(data.getClass().getComponentType())) {
            return ModelUtil.copy((JbootModel[])data);
        }
        throw this.newException(null, inv, data);
    }

    private JbootException newException(Exception ex, Invocation inv, Object data) {
        String msg = "Can not copy data for type [" + data.getClass().getName() + "] in method :" + ClassUtil.buildMethodString(inv.getMethod()) + " , can not use @Cacheable(returnCopyEnable=true) annotation";
        return ex == null ? new JbootException(msg) : new JbootException(msg, ex);
    }
}

