/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.cache.interceptor;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import com.jfinal.core.Action;
import com.jfinal.core.CPI;
import com.jfinal.core.Controller;
import io.jboot.components.cache.AopCache;
import io.jboot.components.cache.annotation.CachePut;
import io.jboot.components.cache.interceptor.CacheableInterceptor;
import io.jboot.components.cache.interceptor.Utils;
import io.jboot.utils.AnnotationUtil;
import io.jboot.web.cached.CacheSupportResponseProxy;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CachePutInterceptor
implements Interceptor {
    public void intercept(Invocation inv) {
        Method method = inv.getMethod();
        CachePut cachePut = method.getAnnotation(CachePut.class);
        if (cachePut == null || inv.isActionInvocation() && !CacheableInterceptor.isActionCacheEnable()) {
            inv.invoke();
            return;
        }
        if (inv.isActionInvocation()) {
            this.forController(inv, method, cachePut);
        } else {
            this.forService(inv, method, cachePut);
        }
    }

    private void forController(Invocation inv, Method method, CachePut cachePut) {
        String unless = AnnotationUtil.get(cachePut.unless());
        if (Utils.isUnless(unless, method, inv.getArgs())) {
            return;
        }
        Class<?> targetClass = inv.getTarget().getClass();
        String cacheName = AnnotationUtil.get(cachePut.name());
        Utils.ensureCacheNameNotBlank(method, cacheName);
        String cacheKey = Utils.buildCacheKey(AnnotationUtil.get(cachePut.key()), targetClass, method, inv.getArgs());
        Controller controller = inv.getController();
        CacheSupportResponseProxy responseProxy = new CacheSupportResponseProxy(controller.getResponse());
        responseProxy.setCacheName(cacheName);
        responseProxy.setCacheKey(cacheKey);
        responseProxy.setCacheLiveSeconds(cachePut.liveSeconds());
        CPI._init_((Controller)controller, (Action)CPI.getAction((Controller)controller), (HttpServletRequest)controller.getRequest(), (HttpServletResponse)responseProxy, (String)controller.getPara());
        inv.invoke();
    }

    private void forService(Invocation inv, Method method, CachePut cachePut) {
        inv.invoke();
        Object data = inv.getReturnValue();
        String unless = AnnotationUtil.get(cachePut.unless());
        if (Utils.isUnless(unless, method, inv.getArgs())) {
            return;
        }
        Class<?> targetClass = inv.getTarget().getClass();
        String cacheName = AnnotationUtil.get(cachePut.name());
        Utils.ensureCacheNameNotBlank(method, cacheName);
        String cacheKey = Utils.buildCacheKey(AnnotationUtil.get(cachePut.key()), targetClass, method, inv.getArgs());
        AopCache.putDataToCache(cacheName, cacheKey, data, cachePut.liveSeconds());
    }
}

