/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.cache.interceptor;

import io.jboot.aop.InterceptorBuilder;
import io.jboot.aop.Interceptors;
import io.jboot.aop.annotation.AutoLoad;
import io.jboot.components.cache.annotation.CacheEvict;
import io.jboot.components.cache.annotation.CachePut;
import io.jboot.components.cache.annotation.Cacheable;
import io.jboot.components.cache.annotation.CachesEvict;
import io.jboot.components.cache.interceptor.CacheEvictInterceptor;
import io.jboot.components.cache.interceptor.CachePutInterceptor;
import io.jboot.components.cache.interceptor.CacheableInterceptor;
import io.jboot.components.cache.interceptor.CachesEvictInterceptor;
import java.lang.reflect.Method;

@AutoLoad
public class CacheInterceptorBuilder
implements InterceptorBuilder {
    public static final int INTERCEPTOR_WEIGHT = 100;

    @Override
    public void build(Class<?> targetClass, Method method, Interceptors interceptors) {
        if (InterceptorBuilder.Util.hasAnnotation(method, CacheEvict.class)) {
            interceptors.add(CacheEvictInterceptor.class, 100);
        }
        if (InterceptorBuilder.Util.hasAnnotation(method, Cacheable.class)) {
            interceptors.add(CacheableInterceptor.class, 100);
        }
        if (InterceptorBuilder.Util.hasAnnotation(method, CachePut.class)) {
            interceptors.add(CachePutInterceptor.class, 100);
        }
        if (InterceptorBuilder.Util.hasAnnotation(method, CachesEvict.class)) {
            interceptors.add(CachesEvictInterceptor.class, 100);
        }
    }
}

