/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.cache.ehredis;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.jfinal.plugin.ehcache.IDataLoader;
import io.jboot.Jboot;
import io.jboot.components.cache.JbootCacheBase;
import io.jboot.components.cache.JbootCacheConfig;
import io.jboot.components.cache.ehcache.JbootEhcacheImpl;
import io.jboot.components.cache.ehredis.JbootEhredisMessage;
import io.jboot.components.cache.redis.JbootRedisCacheImpl;
import io.jboot.components.serializer.JbootSerializer;
import io.jboot.support.redis.JbootRedis;
import io.jboot.utils.StrUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.CacheEventListener;
import redis.clients.jedis.BinaryJedisPubSub;

public class JbootEhredisCacheImpl
extends JbootCacheBase
implements CacheEventListener {
    public static final String DEFAULT_NOTIFY_CHANNEL = "jboot_ehredis_channel";
    private JbootEhcacheImpl ehcacheImpl;
    private JbootRedisCacheImpl redisCacheImpl;
    private JbootRedis redis;
    private JbootSerializer serializer;
    private String channel = "jboot_ehredis_channel";
    private String clientId;
    private LoadingCache<String, List> keysCache = Caffeine.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).expireAfterWrite(10L, TimeUnit.MINUTES).build(key -> null);

    public JbootEhredisCacheImpl(JbootCacheConfig config) {
        super(config);
        this.ehcacheImpl = new JbootEhcacheImpl(config);
        this.ehcacheImpl.setCacheEventListener(this);
        this.redisCacheImpl = new JbootRedisCacheImpl(config);
        this.clientId = StrUtil.uuid();
        this.serializer = Jboot.getSerializer();
        this.redis = this.redisCacheImpl.getRedis();
        this.redis.subscribe(new BinaryJedisPubSub(){

            public void onMessage(byte[] channel, byte[] message) {
                JbootEhredisCacheImpl.this.onMessage((String)JbootEhredisCacheImpl.this.serializer.deserialize(channel), JbootEhredisCacheImpl.this.serializer.deserialize(message));
            }
        }, new byte[][]{this.serializer.serialize(this.channel)});
    }

    @Override
    public <T> T get(String cacheName, Object key) {
        Object value = this.ehcacheImpl.get(cacheName, key);
        if (value == null && (value = this.redisCacheImpl.get(cacheName, key)) != null) {
            Integer ttl = this.redisCacheImpl.getTtl(cacheName, key);
            if (ttl != null && ttl > 0) {
                this.ehcacheImpl.put(cacheName, key, value, ttl);
            } else {
                this.ehcacheImpl.put(cacheName, key, value);
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String cacheName, Object key, Object value) {
        try {
            this.ehcacheImpl.put(cacheName, key, value);
            this.redisCacheImpl.put(cacheName, key, value);
        }
        finally {
            this.publishMessage(1, cacheName, key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String cacheName, Object key, Object value, int liveSeconds) {
        if (liveSeconds <= 0) {
            this.put(cacheName, key, value);
            return;
        }
        try {
            this.ehcacheImpl.put(cacheName, key, value, liveSeconds);
            this.redisCacheImpl.put(cacheName, key, value, liveSeconds);
        }
        finally {
            this.publishMessage(1, cacheName, key);
        }
    }

    @Override
    public void remove(String cacheName, Object key) {
        try {
            this.ehcacheImpl.remove(cacheName, key);
            this.redisCacheImpl.remove(cacheName, key);
        }
        finally {
            this.publishMessage(2, cacheName, key);
        }
    }

    @Override
    public void removeAll(String cacheName) {
        try {
            this.ehcacheImpl.removeAll(cacheName);
            this.redisCacheImpl.removeAll(cacheName);
        }
        finally {
            this.publishMessage(3, cacheName, null);
        }
    }

    @Override
    public <T> T get(String cacheName, Object key, IDataLoader dataLoader) {
        Object value = this.get(cacheName, key);
        if (value != null) {
            return value;
        }
        value = dataLoader.load();
        if (value != null) {
            this.put(cacheName, key, value);
        }
        return value;
    }

    @Override
    public <T> T get(String cacheName, Object key, IDataLoader dataLoader, int liveSeconds) {
        if (liveSeconds <= 0) {
            return this.get(cacheName, key, dataLoader);
        }
        Object value = this.get(cacheName, key);
        if (value != null) {
            return value;
        }
        value = dataLoader.load();
        if (value != null) {
            this.put(cacheName, key, value, liveSeconds);
        }
        return value;
    }

    @Override
    public Integer getTtl(String cacheName, Object key) {
        Integer ttl = this.ehcacheImpl.getTtl(cacheName, key);
        if (ttl == null) {
            ttl = this.redisCacheImpl.getTtl(cacheName, key);
        }
        return ttl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTtl(String cacheName, Object key, int seconds) {
        try {
            this.ehcacheImpl.setTtl(cacheName, key, seconds);
            this.redisCacheImpl.setTtl(cacheName, key, seconds);
        }
        finally {
            this.publishMessage(2, cacheName, key);
        }
    }

    private void publishMessage(int action, String cacheName, Object key) {
        this.clearKeysCache(cacheName);
        JbootEhredisMessage message = new JbootEhredisMessage(this.clientId, action, cacheName, key);
        this.redis.publish(this.serializer.serialize(this.channel), this.serializer.serialize(message));
    }

    private void clearKeysCache(String cacheName) {
        this.keysCache.invalidate((Object)cacheName);
    }

    @Override
    public void refresh(String cacheName, Object key) {
        this.publishMessage(2, cacheName, key);
    }

    @Override
    public void refresh(String cacheName) {
        this.publishMessage(3, cacheName, null);
    }

    @Override
    public List getNames() {
        return this.redisCacheImpl.getNames();
    }

    @Override
    public List getKeys(String cacheName) {
        List list = (ArrayList)this.keysCache.getIfPresent((Object)cacheName);
        if (list == null) {
            list = this.redisCacheImpl.getKeys(cacheName);
            if (list == null) {
                list = new ArrayList();
            }
            this.keysCache.put((Object)cacheName, list);
        }
        return list;
    }

    public void onMessage(String channel, Object obj) {
        JbootEhredisMessage message = (JbootEhredisMessage)obj;
        if (this.clientId.equals(message.getClientId())) {
            return;
        }
        this.clearKeysCache(message.getCacheName());
        switch (message.getAction()) {
            case 1: 
            case 2: {
                this.ehcacheImpl.remove(message.getCacheName(), message.getKey());
                break;
            }
            case 3: {
                this.ehcacheImpl.removeAll(message.getCacheName());
            }
        }
    }

    public JbootEhcacheImpl getEhcacheImpl() {
        return this.ehcacheImpl;
    }

    public JbootRedisCacheImpl getRedisCacheImpl() {
        return this.redisCacheImpl;
    }

    public void notifyElementRemoved(Ehcache cache, Element element) throws CacheException {
    }

    public void notifyElementPut(Ehcache cache, Element element) throws CacheException {
    }

    public void notifyElementUpdated(Ehcache cache, Element element) throws CacheException {
    }

    public void notifyElementExpired(Ehcache cache, Element element) {
        this.clearKeysCache(cache.getName());
    }

    public void notifyElementEvicted(Ehcache cache, Element element) {
    }

    public void notifyRemoveAll(Ehcache cache) {
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public void dispose() {
    }
}

