/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.cache.caredis;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.jfinal.plugin.ehcache.IDataLoader;
import io.jboot.Jboot;
import io.jboot.components.cache.JbootCacheBase;
import io.jboot.components.cache.JbootCacheConfig;
import io.jboot.components.cache.caffeine.CaffeineCacheImpl;
import io.jboot.components.cache.caredis.JbootCaredisMessage;
import io.jboot.components.cache.redis.JbootRedisCacheImpl;
import io.jboot.components.serializer.JbootSerializer;
import io.jboot.support.redis.JbootRedis;
import io.jboot.utils.StrUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import redis.clients.jedis.BinaryJedisPubSub;

public class JbootCaredisCacheImpl
extends JbootCacheBase {
    public static final String DEFAULT_NOTIFY_CHANNEL = "jboot_caredis_channel";
    private CaffeineCacheImpl caffeineCacheImpl;
    private JbootRedisCacheImpl redisCacheImpl;
    private JbootRedis redis;
    private JbootSerializer serializer;
    private String channel = "jboot_caredis_channel";
    private String clientId;
    private Cache<String, List> keysCache = Caffeine.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).expireAfterWrite(10L, TimeUnit.MINUTES).build();

    public JbootCaredisCacheImpl(JbootCacheConfig config) {
        super(config);
        this.caffeineCacheImpl = new CaffeineCacheImpl(config);
        this.redisCacheImpl = new JbootRedisCacheImpl(config);
        this.clientId = StrUtil.uuid();
        this.serializer = Jboot.getSerializer();
        this.redis = this.redisCacheImpl.getRedis();
        this.redis.subscribe(new BinaryJedisPubSub(){

            public void onMessage(byte[] channel, byte[] message) {
                JbootCaredisCacheImpl.this.onMessage((String)JbootCaredisCacheImpl.this.serializer.deserialize(channel), JbootCaredisCacheImpl.this.serializer.deserialize(message));
            }
        }, new byte[][]{this.serializer.serialize(this.channel)});
    }

    @Override
    public <T> T get(String cacheName, Object key) {
        Object value = this.caffeineCacheImpl.get(cacheName, key);
        if (value == null && (value = this.redisCacheImpl.get(cacheName, key)) != null) {
            Integer ttl = this.redisCacheImpl.getTtl(cacheName, key);
            if (ttl != null && ttl > 0) {
                this.caffeineCacheImpl.put(cacheName, key, value, ttl);
            } else {
                this.caffeineCacheImpl.put(cacheName, key, value);
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String cacheName, Object key, Object value) {
        try {
            this.caffeineCacheImpl.put(cacheName, key, value);
            this.redisCacheImpl.put(cacheName, key, value);
        }
        finally {
            this.publishMessage(1, cacheName, key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String cacheName, Object key, Object value, int liveSeconds) {
        if (liveSeconds <= 0) {
            this.put(cacheName, key, value);
            return;
        }
        try {
            this.caffeineCacheImpl.put(cacheName, key, value, liveSeconds);
            this.redisCacheImpl.put(cacheName, key, value, liveSeconds);
        }
        finally {
            this.publishMessage(1, cacheName, key);
        }
    }

    @Override
    public void remove(String cacheName, Object key) {
        try {
            this.caffeineCacheImpl.remove(cacheName, key);
            this.redisCacheImpl.remove(cacheName, key);
        }
        finally {
            this.publishMessage(2, cacheName, key);
        }
    }

    @Override
    public void removeAll(String cacheName) {
        try {
            this.caffeineCacheImpl.removeAll(cacheName);
            this.redisCacheImpl.removeAll(cacheName);
        }
        finally {
            this.publishMessage(3, cacheName, null);
        }
    }

    @Override
    public <T> T get(String cacheName, Object key, IDataLoader dataLoader) {
        Object value = this.get(cacheName, key);
        if (value != null) {
            return value;
        }
        value = dataLoader.load();
        if (value != null) {
            this.put(cacheName, key, value);
        }
        return value;
    }

    @Override
    public <T> T get(String cacheName, Object key, IDataLoader dataLoader, int liveSeconds) {
        if (liveSeconds <= 0) {
            return this.get(cacheName, key, dataLoader);
        }
        Object value = this.get(cacheName, key);
        if (value != null) {
            return value;
        }
        value = dataLoader.load();
        if (value != null) {
            this.put(cacheName, key, value, liveSeconds);
        }
        return value;
    }

    @Override
    public Integer getTtl(String cacheName, Object key) {
        Integer ttl = this.caffeineCacheImpl.getTtl(cacheName, key);
        if (ttl == null) {
            ttl = this.redisCacheImpl.getTtl(cacheName, key);
        }
        return ttl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTtl(String cacheName, Object key, int seconds) {
        try {
            this.caffeineCacheImpl.setTtl(cacheName, key, seconds);
            this.redisCacheImpl.setTtl(cacheName, key, seconds);
        }
        finally {
            this.publishMessage(2, cacheName, key);
        }
    }

    @Override
    public void refresh(String cacheName, Object key) {
        this.publishMessage(2, cacheName, key);
    }

    @Override
    public void refresh(String cacheName) {
        this.publishMessage(3, cacheName, null);
    }

    @Override
    public List getNames() {
        return this.redisCacheImpl.getNames();
    }

    @Override
    public List getKeys(String cacheName) {
        List list = (ArrayList)this.keysCache.getIfPresent((Object)cacheName);
        if (list != null) {
            return list;
        }
        list = this.redisCacheImpl.getKeys(cacheName);
        if (list == null) {
            list = new ArrayList();
        }
        this.keysCache.put((Object)cacheName, list);
        return list;
    }

    private void publishMessage(int action, String cacheName, Object key) {
        this.clearKeysCache(cacheName);
        JbootCaredisMessage message = new JbootCaredisMessage(this.clientId, action, cacheName, key);
        this.redis.publish(this.serializer.serialize(this.channel), this.serializer.serialize(message));
    }

    private void clearKeysCache(String cacheName) {
        this.keysCache.invalidate((Object)cacheName);
    }

    public void onMessage(String channel, Object obj) {
        JbootCaredisMessage message = (JbootCaredisMessage)obj;
        if (this.clientId.equals(message.getClientId())) {
            return;
        }
        this.clearKeysCache(message.getCacheName());
        switch (message.getAction()) {
            case 1: 
            case 2: {
                this.caffeineCacheImpl.remove(message.getCacheName(), message.getKey());
                break;
            }
            case 3: {
                this.caffeineCacheImpl.removeAll(message.getCacheName());
            }
        }
    }

    public CaffeineCacheImpl getCaffeineCacheImpl() {
        return this.caffeineCacheImpl;
    }

    public JbootRedisCacheImpl getRedisCacheImpl() {
        return this.redisCacheImpl;
    }
}

