/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.cache;

import io.jboot.Jboot;
import io.jboot.components.cache.JbootCache;
import io.jboot.components.cache.JbootCacheConfig;
import io.jboot.components.cache.caffeine.CaffeineCacheImpl;
import io.jboot.components.cache.caredis.JbootCaredisCacheImpl;
import io.jboot.components.cache.ehcache.JbootEhcacheImpl;
import io.jboot.components.cache.ehredis.JbootEhredisCacheImpl;
import io.jboot.components.cache.j2cache.J2cacheImpl;
import io.jboot.components.cache.none.NoneCacheImpl;
import io.jboot.components.cache.redis.JbootRedisCacheImpl;
import io.jboot.core.spi.JbootSpiLoader;
import io.jboot.exception.JbootIllegalConfigException;
import io.jboot.utils.ConfigUtil;
import io.jboot.utils.StrUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class JbootCacheManager {
    private static JbootCacheManager me = new JbootCacheManager();
    private Map<String, JbootCache> cacheMap = new ConcurrentHashMap<String, JbootCache>();

    private JbootCacheManager() {
    }

    public static JbootCacheManager me() {
        return me;
    }

    public JbootCache getCache() {
        return this.getCache("default");
    }

    public JbootCache getCache(String name) {
        if (StrUtil.isBlank((String)name)) {
            throw new IllegalArgumentException("cache name must not be null or blank.");
        }
        JbootCache cache = this.cacheMap.get(name);
        if (cache == null) {
            Map<String, JbootCacheConfig> configModels = ConfigUtil.getConfigModels(JbootCacheConfig.class);
            JbootCacheConfig.TYPES.forEach(configModels::remove);
            configModels.putIfAbsent("default", Jboot.config(JbootCacheConfig.class));
            if (!configModels.containsKey(name)) {
                throw new JbootIllegalConfigException("Please config \"jboot.cache." + name + ".type\" in your jboot.properties.");
            }
            JbootCacheConfig cacheConfig = configModels.get(name);
            JbootCache newCache = this.buildCache(cacheConfig);
            if (newCache != null) {
                this.cacheMap.putIfAbsent(name, newCache);
            }
            cache = this.cacheMap.get(name);
        }
        return cache;
    }

    private synchronized JbootCache buildCache(JbootCacheConfig config) {
        switch (config.getType()) {
            case "ehcache": {
                return new JbootEhcacheImpl(config);
            }
            case "redis": {
                return new JbootRedisCacheImpl(config);
            }
            case "ehredis": {
                return new JbootEhredisCacheImpl(config);
            }
            case "j2cache": {
                return new J2cacheImpl(config);
            }
            case "caffeine": {
                return new CaffeineCacheImpl(config);
            }
            case "caredis": {
                return new JbootCaredisCacheImpl(config);
            }
            case "none": {
                return new NoneCacheImpl(config);
            }
        }
        return JbootSpiLoader.load(JbootCache.class, config.getType(), config);
    }
}

