/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.cache;

import io.jboot.components.cache.JbootCache;
import io.jboot.components.cache.JbootCacheConfig;
import io.jboot.utils.StrUtil;

public abstract class JbootCacheBase
implements JbootCache {
    protected JbootCacheConfig config;
    private ThreadLocal<String> CACHE_NAME_PREFIX_TL = new ThreadLocal();

    public JbootCacheBase(JbootCacheConfig config) {
        this.config = config;
    }

    @Override
    public JbootCacheConfig getConfig() {
        return this.config;
    }

    @Override
    public JbootCache setCurrentCacheNamePrefix(String cacheNamePrefix) {
        if (StrUtil.isNotBlank(cacheNamePrefix)) {
            this.CACHE_NAME_PREFIX_TL.set(cacheNamePrefix);
        } else {
            this.CACHE_NAME_PREFIX_TL.remove();
        }
        return this;
    }

    @Override
    public void removeCurrentCacheNamePrefix() {
        this.CACHE_NAME_PREFIX_TL.remove();
    }

    protected String buildCacheName(String cacheName) {
        String cacheNamePrefix = this.CACHE_NAME_PREFIX_TL.get();
        if (StrUtil.isBlank((String)cacheNamePrefix)) {
            cacheNamePrefix = this.config.getDefaultCachePrefix();
        }
        if (StrUtil.isBlank((String)cacheNamePrefix)) {
            return cacheName;
        }
        return cacheNamePrefix + ":" + cacheName;
    }

    @Override
    public void refresh(String cacheName, Object key) {
    }

    @Override
    public void refresh(String cacheName) {
    }
}

