/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.cache;

import com.jfinal.log.Log;
import com.jfinal.plugin.ehcache.IDataLoader;
import io.jboot.components.cache.AopCacheConfig;
import io.jboot.components.cache.JbootCache;
import io.jboot.components.cache.JbootCacheManager;
import java.util.List;

public class AopCache {
    private static final Log LOG = Log.getLog(AopCache.class);
    private static JbootCache aopCache;
    private static final AopCacheConfig CONFIG;

    public static JbootCache setCurrentPrefix(String cacheNamePrefix) {
        return AopCache.getAopCache().setCurrentCacheNamePrefix(cacheNamePrefix);
    }

    public static void clearCurrentPrefix() {
        AopCache.getAopCache().removeCurrentCacheNamePrefix();
    }

    static JbootCache getAopCache() {
        if (aopCache == null) {
            aopCache = JbootCacheManager.me().getCache(AopCacheConfig.getInstance().getUseCacheName());
        }
        return aopCache;
    }

    public static void setAopCache(JbootCache aopCache) {
        AopCache.aopCache = aopCache;
    }

    public static void put(String cacheName, Object key, Object value) {
        try {
            AopCache.getAopCache().put(cacheName, key, value);
        }
        catch (Exception ex) {
            LOG.error(ex.toString(), (Throwable)ex);
        }
    }

    public static void put(String cacheName, Object key, Object value, int liveSeconds) {
        try {
            AopCache.getAopCache().put(cacheName, key, value, liveSeconds);
        }
        catch (Exception ex) {
            LOG.error(ex.toString(), (Throwable)ex);
        }
    }

    public static List getKeys(String cacheName) {
        try {
            return AopCache.getAopCache().getKeys(cacheName);
        }
        catch (Exception ex) {
            LOG.error(ex.toString(), (Throwable)ex);
            return null;
        }
    }

    public static void remove(String cacheName, Object key) {
        try {
            AopCache.getAopCache().remove(cacheName, key);
        }
        catch (Exception ex) {
            LOG.error(ex.toString(), (Throwable)ex);
        }
    }

    public static void removeAll(String cacheName) {
        try {
            AopCache.getAopCache().removeAll(cacheName);
        }
        catch (Exception ex) {
            LOG.error(ex.toString(), (Throwable)ex);
        }
    }

    public static <T> T get(String cacheName, Object key) {
        try {
            return AopCache.getAopCache().get(cacheName, key);
        }
        catch (Exception ex) {
            LOG.error(ex.toString(), (Throwable)ex);
            AopCache.remove(cacheName, key);
            return null;
        }
    }

    public static <T> T get(String cacheName, Object key, IDataLoader dataLoader) {
        try {
            return AopCache.getAopCache().get(cacheName, key, dataLoader);
        }
        catch (Exception ex) {
            LOG.error(ex.toString(), (Throwable)ex);
            AopCache.remove(cacheName, key);
            return null;
        }
    }

    public static <T> T get(String cacheName, Object key, IDataLoader dataLoader, int liveSeconds) {
        try {
            return AopCache.getAopCache().get(cacheName, key, dataLoader, liveSeconds);
        }
        catch (Exception ex) {
            LOG.error(ex.toString(), (Throwable)ex);
            AopCache.remove(cacheName, key);
            return null;
        }
    }

    public static Integer getTtl(String cacheName, Object key) {
        try {
            return AopCache.getAopCache().getTtl(cacheName, key);
        }
        catch (Exception ex) {
            LOG.error(ex.toString(), (Throwable)ex);
            return null;
        }
    }

    public static void setTtl(String cacheName, Object key, int seconds) {
        try {
            AopCache.getAopCache().setTtl(cacheName, key, seconds);
        }
        catch (Exception ex) {
            LOG.error(ex.toString(), (Throwable)ex);
        }
    }

    public static void putDataToCache(String cacheName, String cacheKey, Object data, int liveSeconds) {
        int n = liveSeconds = liveSeconds > 0 ? liveSeconds : CONFIG.getLiveSeconds();
        if (liveSeconds > 0) {
            AopCache.put(cacheName, cacheKey, data, liveSeconds);
        } else {
            AopCache.put(cacheName, cacheKey, data);
        }
    }

    static {
        CONFIG = AopCacheConfig.getInstance();
    }
}

