/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.cache;

import com.jfinal.log.Log;
import com.jfinal.plugin.ehcache.IDataLoader;
import io.jboot.components.cache.ActionCacheConfig;
import io.jboot.components.cache.AopCacheConfig;
import io.jboot.components.cache.JbootCache;
import io.jboot.components.cache.JbootCacheManager;
import java.util.List;

public class ActionCache {
    private static final Log LOG = Log.getLog(ActionCache.class);
    private static JbootCache actionCache;
    private static final ActionCacheConfig CONFIG;

    public static JbootCache setCurrentPrefix(String cacheNamePrefix) {
        return ActionCache.getActionCache().setCurrentCacheNamePrefix(cacheNamePrefix);
    }

    public static void clearCurrentPrefix() {
        ActionCache.getActionCache().removeCurrentCacheNamePrefix();
    }

    static JbootCache getActionCache() {
        if (actionCache == null) {
            actionCache = JbootCacheManager.me().getCache(AopCacheConfig.getInstance().getUseCacheName());
        }
        return actionCache;
    }

    public static void setActionCache(JbootCache actionCache) {
        ActionCache.actionCache = actionCache;
    }

    public static void put(String cacheName, Object key, Object value) {
        try {
            ActionCache.getActionCache().put(cacheName, key, value);
        }
        catch (Exception ex) {
            LOG.error(ex.toString(), (Throwable)ex);
        }
    }

    public static void put(String cacheName, Object key, Object value, int liveSeconds) {
        try {
            ActionCache.getActionCache().put(cacheName, key, value, liveSeconds);
        }
        catch (Exception ex) {
            LOG.error(ex.toString(), (Throwable)ex);
        }
    }

    public static List getKeys(String cacheName) {
        try {
            return ActionCache.getActionCache().getKeys(cacheName);
        }
        catch (Exception ex) {
            LOG.error(ex.toString(), (Throwable)ex);
            return null;
        }
    }

    public static void remove(String cacheName, Object key) {
        try {
            ActionCache.getActionCache().remove(cacheName, key);
        }
        catch (Exception ex) {
            LOG.error(ex.toString(), (Throwable)ex);
        }
    }

    public static void removeAll(String cacheName) {
        try {
            ActionCache.getActionCache().removeAll(cacheName);
        }
        catch (Exception ex) {
            LOG.error(ex.toString(), (Throwable)ex);
        }
    }

    public static <T> T get(String cacheName, Object key) {
        try {
            return ActionCache.getActionCache().get(cacheName, key);
        }
        catch (Exception ex) {
            LOG.error(ex.toString(), (Throwable)ex);
            ActionCache.remove(cacheName, key);
            return null;
        }
    }

    public static <T> T get(String cacheName, Object key, IDataLoader dataLoader) {
        try {
            return ActionCache.getActionCache().get(cacheName, key, dataLoader);
        }
        catch (Exception ex) {
            LOG.error(ex.toString(), (Throwable)ex);
            ActionCache.remove(cacheName, key);
            return null;
        }
    }

    public static <T> T get(String cacheName, Object key, IDataLoader dataLoader, int liveSeconds) {
        try {
            return ActionCache.getActionCache().get(cacheName, key, dataLoader, liveSeconds);
        }
        catch (Exception ex) {
            LOG.error(ex.toString(), (Throwable)ex);
            ActionCache.remove(cacheName, key);
            return null;
        }
    }

    public static Integer getTtl(String cacheName, Object key) {
        try {
            return ActionCache.getActionCache().getTtl(cacheName, key);
        }
        catch (Exception ex) {
            LOG.error(ex.toString(), (Throwable)ex);
            return null;
        }
    }

    public static void setTtl(String cacheName, Object key, int seconds) {
        try {
            ActionCache.getActionCache().setTtl(cacheName, key, seconds);
        }
        catch (Exception ex) {
            LOG.error(ex.toString(), (Throwable)ex);
        }
    }

    public static void putDataToCache(String cacheName, String cacheKey, Object data, int liveSeconds) {
        int n = liveSeconds = liveSeconds > 0 ? liveSeconds : CONFIG.getLiveSeconds();
        if (liveSeconds > 0) {
            ActionCache.put(cacheName, cacheKey, data, liveSeconds);
        } else {
            ActionCache.put(cacheName, cacheKey, data);
        }
    }

    static {
        CONFIG = ActionCacheConfig.getInstance();
    }
}

