/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.codegen.service;

import com.jfinal.core.JFinal;
import com.jfinal.kit.JavaKeyword;
import com.jfinal.kit.Kv;
import com.jfinal.kit.StrKit;
import com.jfinal.plugin.activerecord.generator.MetaBuilder;
import com.jfinal.plugin.activerecord.generator.TableMeta;
import com.jfinal.template.Engine;
import com.jfinal.template.source.ClassPathSourceFactory;
import com.jfinal.template.source.ISourceFactory;
import io.jboot.codegen.CodeGenHelpler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JbootServiceImplGenerator {
    private String basePackage;
    private String implPackage;
    private String modelPackage;
    private MetaBuilder metaBuilder;
    private String template;
    private String implName = "impl";
    private String outputDir;
    protected Map<String, String> getterTypeMap = new HashMap<String, String>(){
        {
            this.put("java.lang.String", "getStr");
            this.put("java.lang.Integer", "getInt");
            this.put("java.lang.Long", "getLong");
            this.put("java.lang.Double", "getDouble");
            this.put("java.lang.Float", "getFloat");
            this.put("java.lang.Short", "getShort");
            this.put("java.lang.Byte", "getByte");
        }
    };

    public JbootServiceImplGenerator(String basePackage, String modelPackage) {
        this.basePackage = basePackage;
        this.modelPackage = modelPackage;
        this.template = "io/jboot/codegen/service/service_impl_template.tp";
        this.metaBuilder = CodeGenHelpler.createMetaBuilder();
        this.outputDir = this.buildOutPutDir();
    }

    public JbootServiceImplGenerator(String basePackage, String implPackage, String outputDir, String modelPackage) {
        this.basePackage = basePackage;
        this.implPackage = implPackage;
        this.modelPackage = modelPackage;
        this.template = "io/jboot/codegen/service/service_impl_template.tp";
        this.metaBuilder = CodeGenHelpler.createMetaBuilder();
        this.outputDir = outputDir;
    }

    private String buildOutPutDir() {
        return CodeGenHelpler.getUserDir() + "/src/main/java/" + (this.basePackage + "." + this.implName).replace(".", "/");
    }

    public void generate() {
        this.generate(this.metaBuilder.build());
    }

    public JbootServiceImplGenerator setRemovedTableNamePrefixes(String ... prefixes) {
        this.metaBuilder.setRemovedTableNamePrefixes(prefixes);
        return this;
    }

    public JbootServiceImplGenerator addExcludedTable(String ... excludedTables) {
        this.metaBuilder.addExcludedTable(excludedTables);
        return this;
    }

    public JbootServiceImplGenerator setGenerateRemarks(boolean generateRemarks) {
        this.metaBuilder.setGenerateRemarks(generateRemarks);
        return this;
    }

    public JbootServiceImplGenerator setImplName(String implName) {
        this.implName = implName;
        return this;
    }

    public void generate(List<TableMeta> tableMetas) {
        System.out.println("Generate Service Impl ...");
        System.out.println("Service Impl Output Dir: " + this.outputDir);
        Engine engine = Engine.create((String)"forServiceImpl");
        engine.setSourceFactory((ISourceFactory)new ClassPathSourceFactory());
        engine.addSharedMethod((Object)new StrKit());
        engine.addSharedObject("getterTypeMap", this.getterTypeMap);
        engine.addSharedObject("javaKeyword", (Object)JavaKeyword.me);
        for (TableMeta tableMeta : tableMetas) {
            this.genBaseModelContent(tableMeta);
        }
        this.writeToFile(tableMetas);
    }

    protected void genBaseModelContent(TableMeta tableMeta) {
        Kv data = Kv.by((Object)"serviceImplPackageName", (Object)(this.implPackage == null ? this.basePackage + "." + this.implName : this.implPackage));
        data.set((Object)"tableMeta", (Object)tableMeta);
        data.set((Object)"basePackage", (Object)this.basePackage);
        data.set((Object)"modelPackage", (Object)this.modelPackage);
        data.set((Object)"implName", (Object)this.implName);
        Engine engine = Engine.use((String)"forServiceImpl");
        tableMeta.baseModelContent = engine.getTemplate(this.template).renderToString((Map)data);
    }

    protected void writeToFile(List<TableMeta> tableMetas) {
        try {
            for (TableMeta tableMeta : tableMetas) {
                this.writeToFile(tableMeta);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void writeToFile(TableMeta tableMeta) throws IOException {
        String target;
        File targetFile;
        File dir = new File(this.outputDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if ((targetFile = new File(target = this.outputDir + File.separator + tableMeta.modelName + "Service" + StrKit.firstCharToUpperCase((String)this.implName) + ".java")).exists()) {
            return;
        }
        try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(target), JFinal.me().getConstants().getEncoding());){
            osw.write(tableMeta.baseModelContent);
        }
    }
}

