/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.app.config.support.nacos;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.jfinal.log.Log;
import io.jboot.app.config.JbootConfigKit;
import io.jboot.app.config.JbootConfigManager;
import io.jboot.app.config.support.nacos.NacosConfigInitializer;
import io.jboot.app.config.support.nacos.NacosServerConfig;
import io.jboot.utils.ConfigUtil;
import java.io.IOException;
import java.io.StringReader;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;

public class NacosConfigManager {
    private static final Log LOG = Log.getLog(NacosConfigManager.class);
    private static final NacosConfigManager ME = new NacosConfigManager();
    private Properties contentProperties;

    public static NacosConfigManager me() {
        return ME;
    }

    public void init(JbootConfigManager configManager) {
        Map<String, NacosServerConfig> configModels = ConfigUtil.getConfigModels(configManager, NacosServerConfig.class);
        configModels.forEach((s, nacosConfig) -> this.initConfig(configManager, (NacosServerConfig)nacosConfig));
    }

    private void initConfig(JbootConfigManager configManager, NacosServerConfig nacosServerConfig) {
        if (nacosServerConfig == null || !nacosServerConfig.isEnable() || !nacosServerConfig.isConfigOk()) {
            return;
        }
        try {
            ConfigService configService = NacosFactory.createConfigService((Properties)nacosServerConfig.toProperties());
            String content = configService.getConfig(nacosServerConfig.getDataId(), nacosServerConfig.getGroup(), 3000L);
            if (JbootConfigKit.isNotBlank(content)) {
                this.contentProperties = this.str2Properties(content);
                if (this.contentProperties != null) {
                    configManager.setRemoteProperties(this.contentProperties);
                }
            }
            new NacosConfigInitializer(this, configManager).initListener(configService, nacosServerConfig);
        }
        catch (Exception e) {
            LOG.error(e.toString(), (Throwable)e);
        }
    }

    public void onReceiveConfigInfo(JbootConfigManager configManager, String configInfo) {
        Properties properties = this.str2Properties(configInfo);
        if (properties != null) {
            if (this.contentProperties == null) {
                this.contentProperties = properties;
                configManager.setRemoteProperties(properties);
            } else {
                for (Object key : properties.keySet()) {
                    String oldValue;
                    String newValue = properties.getProperty(key.toString());
                    if (Objects.equals(newValue, oldValue = this.contentProperties.getProperty(key.toString()))) continue;
                    this.contentProperties.put(key, newValue);
                    configManager.setRemoteProperty(key.toString(), newValue);
                    configManager.notifyChangeListeners(key.toString(), newValue, oldValue);
                }
            }
        }
    }

    private Properties str2Properties(String content) {
        try {
            Properties properties = new Properties();
            properties.load(new StringReader(content));
            return properties;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

