/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.app.config.support.apollo;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.enums.PropertyChangeType;
import com.ctrip.framework.apollo.model.ConfigChange;
import io.jboot.app.config.JbootConfigKit;
import io.jboot.app.config.JbootConfigManager;
import io.jboot.app.config.support.apollo.ApolloServerConfig;
import java.util.HashMap;
import java.util.Set;

public class ApolloConfigManager {
    private static final ApolloConfigManager ME = new ApolloConfigManager();

    public static ApolloConfigManager me() {
        return ME;
    }

    public void init(JbootConfigManager configManager) {
        ApolloServerConfig apolloServerConfig = configManager.get(ApolloServerConfig.class);
        if (!apolloServerConfig.isEnable() || !apolloServerConfig.isConfigOk()) {
            return;
        }
        System.setProperty("app.id", apolloServerConfig.getAppId());
        System.setProperty("apollo.meta", apolloServerConfig.getMeta());
        Config config = this.getDefaultConfig(configManager);
        Set propNames = config.getPropertyNames();
        if (propNames != null && !propNames.isEmpty()) {
            HashMap<String, String> properties = new HashMap<String, String>();
            for (String name : propNames) {
                String value = config.getProperty(name, null);
                properties.put(name, value);
            }
            configManager.setRemoteProperties(properties);
        }
        config.addChangeListener(changeEvent -> {
            for (String key : changeEvent.changedKeys()) {
                ConfigChange change = changeEvent.getChange(key);
                if (change.getChangeType() == PropertyChangeType.DELETED) {
                    configManager.removeRemoteProperty(change.getPropertyName());
                } else {
                    configManager.setRemoteProperty(change.getPropertyName(), change.getNewValue());
                }
                configManager.notifyChangeListeners(change.getPropertyName(), change.getNewValue(), change.getOldValue());
            }
        });
    }

    private Config getDefaultConfig(JbootConfigManager configManager) {
        ApolloServerConfig apolloServerConfig = configManager.get(ApolloServerConfig.class);
        if (JbootConfigKit.isNotBlank(apolloServerConfig.getNamespace())) {
            return ConfigService.getConfig((String)apolloServerConfig.getNamespace());
        }
        return ConfigService.getAppConfig();
    }
}

