/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.app.config;

import com.jfinal.kit.LogKit;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Properties;

class JbootProp {
    protected Properties properties = new Properties();
    private static final String DEFAULT_ENCODING = "UTF-8";

    public JbootProp(String fileName) {
        this(fileName, DEFAULT_ENCODING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JbootProp(String fileName, String encoding) {
        InputStream inputStream = null;
        try {
            String classPath;
            URL resourceURL;
            inputStream = this.getResourceAsStreamByCurrentThread(fileName);
            if (inputStream == null) {
                inputStream = this.getResourceAsStreamByClassloader(fileName);
            }
            if (inputStream == null && (resourceURL = JbootProp.class.getResource("/")) != null && JbootProp.removeSlashEnd(classPath = resourceURL.toURI().getPath()).endsWith("classes")) {
                File propFile = new File(classPath, fileName);
                if (propFile.exists() && propFile.isFile()) {
                    inputStream = new FileInputStream(propFile);
                } else {
                    File resourcesDir = new File(classPath, "../../src/main/resources");
                    propFile = new File(resourcesDir, fileName);
                    if (propFile.exists() && propFile.isFile()) {
                        inputStream = new FileInputStream(propFile);
                    }
                }
            }
            if (inputStream != null) {
                this.properties.load(new InputStreamReader(inputStream, encoding));
            } else if (!fileName.contains("-")) {
                System.err.println("Warning: Can not load properties file in classpath, file name: " + fileName);
            }
        }
        catch (Exception e) {
            System.err.println("Warning: Can not load properties file in classpath, file name: " + fileName);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LogKit.logNothing((Throwable)e);
                }
            }
        }
    }

    private InputStream getResourceAsStreamByCurrentThread(String fileName) {
        ClassLoader ret = Thread.currentThread().getContextClassLoader();
        return ret != null ? ret.getResourceAsStream(fileName) : null;
    }

    private InputStream getResourceAsStreamByClassloader(String fileName) {
        ClassLoader ret = JbootProp.class.getClassLoader();
        return ret != null ? ret.getResourceAsStream(fileName) : null;
    }

    private static String removeSlashEnd(String path) {
        if (path != null && (path.endsWith("/") || path.endsWith("\\"))) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    public JbootProp(File file) {
        try (FileInputStream inputStream = new FileInputStream(file);){
            this.properties.load(new InputStreamReader((InputStream)inputStream, DEFAULT_ENCODING));
        }
        catch (Exception e) {
            System.err.println("Warning: Can not load properties file: " + file);
        }
    }

    public Properties getProperties() {
        return this.properties;
    }
}

