/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.app.config;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.jfinal.kit.LogKit;
import io.jboot.app.config.JbootConfigChangeListener;
import io.jboot.app.config.JbootConfigDecryptor;
import io.jboot.app.config.JbootConfigKit;
import io.jboot.app.config.JbootProp;
import io.jboot.app.config.annotation.ConfigModel;
import io.jboot.app.config.support.apollo.ApolloConfigManager;
import io.jboot.app.config.support.nacos.NacosConfigManager;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;

public class JbootConfigManager {
    private static Map<String, String> argMap;
    private Properties mainProperties;
    private Map remoteProperties;
    private Map<String, Object> configCache = new ConcurrentHashMap<String, Object>();
    private Multimap<String, JbootConfigChangeListener> listenersMultimap = ArrayListMultimap.create();
    private JbootConfigDecryptor decryptor;
    private static JbootConfigManager instance;
    private Boolean devMode = null;

    public static JbootConfigManager me() {
        if (instance == null) {
            instance = new JbootConfigManager();
        }
        return instance;
    }

    private JbootConfigManager() {
        this.init();
    }

    private void init() {
        Properties externalProperties;
        String fileName = this.getConfigValue(null, "jboot_properties_name");
        if (fileName == null || fileName.length() == 0) {
            fileName = "jboot";
        }
        String pathName = this.getConfigValue(null, "jboot_properties_path");
        this.mainProperties = this.getProperties(pathName, fileName + ".properties");
        String mode = this.getConfigValue("jboot.app.mode");
        if (JbootConfigKit.isNotBlank(mode)) {
            String modePropertiesName = fileName + "-" + mode + ".properties";
            Properties modeProperties = this.getProperties(pathName, modePropertiesName);
            this.mainProperties.putAll((Map<?, ?>)modeProperties);
        }
        if ((externalProperties = JbootConfigKit.readExternalProperties(fileName)) != null && !externalProperties.isEmpty()) {
            this.mainProperties.putAll((Map<?, ?>)externalProperties);
        }
        NacosConfigManager.me().init(this);
        ApolloConfigManager.me().init(this);
    }

    private Properties getProperties(String pathName, String name) {
        if (pathName != null && pathName.trim().length() > 0) {
            return new JbootProp(new File(pathName, name)).getProperties();
        }
        return new JbootProp(name).getProperties();
    }

    public JbootConfigDecryptor getDecryptor() {
        return this.decryptor;
    }

    public void setDecryptor(JbootConfigDecryptor decryptor) {
        this.decryptor = decryptor;
    }

    public <T> T get(Class<T> clazz) {
        ConfigModel configModel = clazz.getAnnotation(ConfigModel.class);
        if (configModel == null) {
            return this.get(clazz, null, null);
        }
        return this.get(clazz, configModel.prefix(), configModel.file());
    }

    public <T> T get(Class<T> clazz, String prefix, String file) {
        if (this.isDevMode()) {
            return this.createConfigObject(clazz, prefix, file);
        }
        Object configObject = this.configCache.get(clazz.getName() + prefix);
        if (configObject == null) {
            T obj = this.createConfigObject(clazz, prefix, file);
            this.configCache.putIfAbsent(clazz.getName() + prefix, obj);
            configObject = this.configCache.get(clazz.getName() + prefix);
        }
        return (T)configObject;
    }

    public <T> T refreshAndGet(Class<T> clazz) {
        ConfigModel configModel = clazz.getAnnotation(ConfigModel.class);
        if (configModel == null) {
            return this.refreshAndGet(clazz, null, null);
        }
        return this.refreshAndGet(clazz, configModel.prefix(), configModel.file());
    }

    public <T> T refreshAndGet(Class<T> clazz, String prefix, String file) {
        this.configCache.remove(clazz.getName() + prefix);
        this.refreshMainProperties();
        return this.get(clazz, prefix, file);
    }

    private void refreshMainProperties() {
        Properties properties = new JbootProp("jboot.properties").getProperties();
        this.mainProperties.putAll((Map<?, ?>)properties);
        String mode = this.getConfigValue(properties, "jboot.app.mode");
        if (JbootConfigKit.isNotBlank(mode)) {
            String modePropertiesName = "jboot-" + mode + ".properties";
            this.mainProperties.putAll((Map<?, ?>)new JbootProp(modePropertiesName).getProperties());
        }
    }

    public synchronized <T> T createConfigObject(Class<T> clazz, String prefix, String file) {
        T configObject = JbootConfigKit.newInstance(clazz);
        for (Method setterMethod : JbootConfigKit.getClassSetMethods(clazz)) {
            Object val;
            JbootProp prop;
            String filePropValue;
            String key = this.buildKey(prefix, setterMethod);
            String value = this.getConfigValue(key);
            if (JbootConfigKit.isNotBlank(file) && JbootConfigKit.isNotBlank(filePropValue = this.getConfigValue((prop = new JbootProp(file)).getProperties(), key))) {
                value = filePropValue;
            }
            if (!JbootConfigKit.isNotBlank(value) || (val = JbootConfigKit.convert(setterMethod.getParameterTypes()[0], value, setterMethod.getGenericParameterTypes()[0])) == null) continue;
            try {
                setterMethod.invoke(configObject, val);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return configObject;
    }

    private String buildKey(String prefix, Method method) {
        String key = JbootConfigKit.firstCharToLowerCase(method.getName().substring(3));
        if (JbootConfigKit.isNotBlank(prefix)) {
            key = prefix.trim() + "." + key;
        }
        return key;
    }

    public String getConfigValue(String key) {
        return this.getConfigValue(this.mainProperties, key);
    }

    public String getConfigValue(Properties properties, String key) {
        if (JbootConfigKit.isBlank(key)) {
            return "";
        }
        String originalValue = this.getOriginalConfigValue(properties, key);
        String stringValue = this.decryptor != null ? this.decryptor.decrypt(key, originalValue) : originalValue;
        return JbootConfigKit.parseValue(stringValue);
    }

    private String getOriginalConfigValue(Properties properties, String key) {
        String value = null;
        if (this.remoteProperties != null && JbootConfigKit.isNotBlank(value = (String)this.remoteProperties.get(key))) {
            return value.trim();
        }
        value = this.getBootArg(key);
        if (JbootConfigKit.isNotBlank(value)) {
            return value.trim();
        }
        value = System.getenv(key);
        if (JbootConfigKit.isNotBlank(value)) {
            return value.trim();
        }
        String tempKey = key.toUpperCase().replace('.', '_');
        value = System.getenv(tempKey);
        if (JbootConfigKit.isNotBlank(value)) {
            return value.trim();
        }
        value = System.getProperty(key);
        if (JbootConfigKit.isNotBlank(value)) {
            return value.trim();
        }
        if (properties != null && JbootConfigKit.isNotBlank(value = (String)properties.get(key))) {
            return value.trim();
        }
        return null;
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.mainProperties);
        if (System.getenv() != null) {
            for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
                properties.put(entry.getKey(), entry.getValue());
            }
        }
        if (System.getProperties() != null) {
            properties.putAll((Map<?, ?>)System.getProperties());
        }
        if (this.getBootArgs() != null) {
            for (Map.Entry<String, String> entry : this.getBootArgs().entrySet()) {
                properties.put(entry.getKey(), entry.getValue());
            }
        }
        if (this.remoteProperties != null) {
            properties.putAll((Map<?, ?>)this.remoteProperties);
        }
        return properties;
    }

    public Map<String, Object> getConfigCache() {
        return this.configCache;
    }

    public synchronized void setRemoteProperty(String key, String value) {
        if (this.remoteProperties == null) {
            this.remoteProperties = new ConcurrentHashMap();
        }
        this.remoteProperties.put(key, value);
    }

    public void removeRemoteProperty(String key) {
        if (this.remoteProperties != null) {
            this.remoteProperties.remove(key);
        }
    }

    public synchronized void setRemoteProperties(Map map) {
        if (this.remoteProperties == null) {
            this.remoteProperties = new ConcurrentHashMap();
        }
        this.remoteProperties.putAll(map);
    }

    public void addConfigChangeListener(JbootConfigChangeListener listener, Class forClass) {
        ConfigModel configModel = forClass.getAnnotation(ConfigModel.class);
        if (configModel == null) {
            throw new IllegalArgumentException("forClass:" + forClass + " has no @ConfigModel annotation");
        }
        String prefix = configModel.prefix();
        List<Method> setterMethods = JbootConfigKit.getClassSetMethods(forClass);
        if (setterMethods != null) {
            for (Method setterMethod : setterMethods) {
                String key = this.buildKey(prefix, setterMethod);
                this.listenersMultimap.put((Object)key, (Object)listener);
            }
        }
    }

    public void addConfigChangeListener(JbootConfigChangeListener listener, String ... forKeys) {
        if (listener == null) {
            throw new NullPointerException("listener must not null.");
        }
        if (forKeys == null || forKeys.length == 0) {
            throw new NullPointerException("forKeys must not null or empty.");
        }
        for (String forKey : forKeys) {
            this.listenersMultimap.put((Object)forKey, (Object)listener);
        }
    }

    public void removeConfigChangeListener(JbootConfigChangeListener listener) {
        this.listenersMultimap.entries().removeIf(entry -> entry.getValue() == listener);
    }

    public void notifyChangeListeners(String key, String newValue, String oldValue) {
        if (key == null) {
            return;
        }
        Collection listeners = this.listenersMultimap.get((Object)key);
        if (listeners == null || listeners.isEmpty()) {
            return;
        }
        for (JbootConfigChangeListener listener : listeners) {
            try {
                listener.onChange(key, newValue, oldValue);
            }
            catch (Throwable ex) {
                LogKit.error((String)ex.toString(), (Throwable)ex);
            }
        }
    }

    public static void parseArgs(String[] args) {
        if (args == null || args.length == 0) {
            return;
        }
        for (String arg : args) {
            int indexOf = arg.indexOf("=");
            if (!arg.startsWith("--") || indexOf <= 0) continue;
            String key = arg.substring(2, indexOf);
            String value = arg.substring(indexOf + 1);
            JbootConfigManager.setBootArg(key, value);
        }
    }

    public static void setBootArg(String key, Object value) {
        if (argMap == null) {
            argMap = new HashMap<String, String>();
        }
        if (key == null) {
            return;
        }
        if (value == null || value.toString().trim().length() == 0) {
            argMap.remove(key.trim());
        } else {
            argMap.put(key.trim(), value.toString().trim());
        }
    }

    public static void setBootProperties(Properties properties) {
        Objects.requireNonNull(properties, "properties must not be null");
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(o, o2) -> JbootConfigManager.setBootArg(o.toString(), o2)));
    }

    public static void setBootProperties(String propertiesFilePath) {
        File file = new File(propertiesFilePath);
        if (file.exists()) {
            JbootConfigManager.setBootProperties(file);
        } else {
            JbootConfigManager.setBootProperties(new JbootProp(propertiesFilePath).getProperties());
        }
    }

    public static void setBootProperties(File propertiesFile) {
        if (propertiesFile.exists()) {
            JbootConfigManager.setBootProperties(new JbootProp(propertiesFile).getProperties());
        } else {
            System.err.println("Warning: properties file not exists: " + propertiesFile);
        }
    }

    public String getBootArg(String key) {
        if (argMap == null) {
            return null;
        }
        return argMap.get(key);
    }

    public Map<String, String> getBootArgs() {
        return argMap;
    }

    public boolean isDevMode() {
        if (this.devMode == null) {
            String appMode = this.getConfigValue("jboot.app.mode");
            this.devMode = null == appMode || "".equals(appMode.trim()) || "dev".equalsIgnoreCase(appMode.trim());
        }
        return this.devMode;
    }

    public void setDevMode(Boolean devMode) {
        this.devMode = devMode;
    }
}

