/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.app.config;

import io.jboot.app.config.ConfigPara;
import io.jboot.app.config.JbootConfigManager;
import io.jboot.app.config.JbootProp;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class JbootConfigKit {
    public static <T> T newInstance(Class<T> clazz) {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<ConfigPara> parseParas(String string) {
        char[] chars;
        if (JbootConfigKit.isBlank(string)) {
            return null;
        }
        LinkedList<ConfigPara> paras = null;
        ConfigPara para = null;
        int index = 0;
        boolean hasDefaultValue = false;
        for (char c : chars = string.toCharArray()) {
            if (c == '{' && index > 0 && chars[index - 1] == '$' && para == null) {
                para = new ConfigPara();
                hasDefaultValue = false;
                para.setStart(index - 1);
            } else if (c == '}' && para != null) {
                para.setEnd(index);
                if (paras == null) {
                    paras = new LinkedList<ConfigPara>();
                }
                paras.add(para);
                para = null;
            } else if (para != null) {
                if (c == ':' && !hasDefaultValue) {
                    hasDefaultValue = true;
                } else if (hasDefaultValue) {
                    para.appendToDefaultValue(c);
                } else {
                    para.appendToKey(c);
                }
            }
            ++index;
        }
        return paras;
    }

    public static String parseValue(String value) {
        List<ConfigPara> paras = JbootConfigKit.parseParas(value);
        if (paras == null || paras.size() == 0) {
            return value;
        }
        JbootConfigManager manager = JbootConfigManager.me();
        StringBuilder retBuilder = new StringBuilder(value.length());
        int index = 0;
        for (ConfigPara para : paras) {
            String configValue;
            if (para.getStart() > index) {
                retBuilder.append(value, index, para.getStart());
            }
            configValue = JbootConfigKit.isNotBlank(configValue = manager.getConfigValue(para.getKey())) ? configValue : para.getDefaultValue();
            retBuilder.append(configValue);
            index = para.getEnd() + 1;
        }
        if (index < value.length()) {
            retBuilder.append(value, index, value.length());
        }
        return retBuilder.toString();
    }

    public static List<Method> getClassSetMethods(Class<?> clazz) {
        Method[] methods;
        ArrayList<Method> setMethods = new ArrayList<Method>();
        for (Method method : methods = clazz.getMethods()) {
            if (!method.getName().startsWith("set") || method.getName().length() <= 3 || !Character.isUpperCase(method.getName().charAt(3)) || method.getParameterCount() != 1 || !Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers())) continue;
            setMethods.add(method);
        }
        return setMethods;
    }

    public static String firstCharToLowerCase(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'A' && firstChar <= 'Z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] + 32);
            return new String(arr);
        }
        return str;
    }

    public static boolean isBlank(String str) {
        if (str == null) {
            return true;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (str.charAt(i) <= ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(Object str) {
        return str != null && !JbootConfigKit.isBlank(str.toString());
    }

    public static boolean areNotBlank(String ... strs) {
        if (strs == null || strs.length == 0) {
            return false;
        }
        for (String string : strs) {
            if (!JbootConfigKit.isBlank(string)) continue;
            return false;
        }
        return true;
    }

    static Properties readExternalProperties(String fileName) {
        String currentJarFilePath = JbootConfigKit.class.getProtectionDomain().getCodeSource().getLocation().getFile();
        File fileDir = new File(currentJarFilePath).getParentFile();
        File externalProperties = new File(fileDir, fileName + ".properties");
        if (externalProperties.exists()) {
            return new JbootProp(externalProperties).getProperties();
        }
        return null;
    }

    public static Object convert(Class<?> convertClass, String s, Type genericType) {
        if (convertClass == String.class || s == null || convertClass == Object.class) {
            return s;
        }
        if (convertClass == Integer.class || convertClass == Integer.TYPE) {
            return Integer.parseInt(s);
        }
        if (convertClass == Long.class || convertClass == Long.TYPE) {
            return Long.parseLong(s);
        }
        if (convertClass == Double.class || convertClass == Double.TYPE) {
            return Double.parseDouble(s);
        }
        if (convertClass == Float.class || convertClass == Float.TYPE) {
            return Float.valueOf(Float.parseFloat(s));
        }
        if (convertClass == Boolean.class || convertClass == Boolean.TYPE) {
            String value = s.toLowerCase();
            if ("1".equals(value) || "true".equals(value)) {
                return Boolean.TRUE;
            }
            if ("0".equals(value) || "false".equals(value)) {
                return Boolean.FALSE;
            }
            throw new RuntimeException("Can not parse to boolean type of value: " + s);
        }
        if (convertClass == BigDecimal.class) {
            return new BigDecimal(s);
        }
        if (convertClass == BigInteger.class) {
            return new BigInteger(s);
        }
        if (convertClass == byte[].class) {
            return s.getBytes();
        }
        if (Map.class.isAssignableFrom(convertClass)) {
            String[] strings;
            if (!s.contains(":") || !JbootConfigKit.genericClassCheck(genericType)) {
                return null;
            }
            AbstractMap map = convertClass == ConcurrentHashMap.class ? new ConcurrentHashMap() : new HashMap();
            for (String kv : strings = s.split(",")) {
                int indexOf = kv.indexOf(":");
                if (indexOf <= 0 || indexOf >= kv.trim().length() - 1) continue;
                map.put(kv.substring(0, indexOf).trim(), kv.substring(indexOf + 1).trim());
            }
            return map;
        }
        if (List.class.isAssignableFrom(convertClass)) {
            if (JbootConfigKit.genericClassCheck(genericType)) {
                String[] strings;
                AbstractList list = LinkedList.class == convertClass ? new LinkedList() : new ArrayList();
                for (String s1 : strings = s.split(",")) {
                    if (s1.trim().length() <= 0) continue;
                    list.add(s1.trim());
                }
                return list;
            }
            return null;
        }
        if (Set.class.isAssignableFrom(convertClass)) {
            if (JbootConfigKit.genericClassCheck(genericType)) {
                String[] strings;
                HashSet set = LinkedHashSet.class == convertClass ? new LinkedHashSet() : new HashSet();
                for (String s1 : strings = s.split(",")) {
                    if (s1.trim().length() <= 0) continue;
                    set.add(s1.trim());
                }
                return set;
            }
            return null;
        }
        if (convertClass.isArray() && convertClass.getComponentType() == String.class) {
            LinkedList<String> list = new LinkedList<String>();
            String[] strings = s.split(",");
            if (strings.length > 0) {
                for (String s1 : strings) {
                    if (s1 == null || s1.trim().length() == 0) continue;
                    list.add(s1.trim());
                }
            }
            return list.toArray(new String[0]);
        }
        if (Class.class == convertClass) {
            try {
                return Class.forName(s, false, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        throw new RuntimeException(convertClass.getName() + " can not be converted, please use other type in your config class!");
    }

    private static boolean genericClassCheck(Type type) {
        if (type instanceof ParameterizedType) {
            for (Type at : ((ParameterizedType)type).getActualTypeArguments()) {
                if (String.class == at) continue;
                return false;
            }
        }
        return true;
    }
}

