/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.app;

import java.io.File;
import java.net.URLDecoder;
import java.util.ArrayList;

public class PathKitExt {
    private static String locationPath = null;
    private static String rootClassPath = null;
    private static String webRootPath = null;
    private static String[] classPathDirs = null;

    public static String getLocationPath() {
        if (locationPath != null) {
            return locationPath;
        }
        try {
            Class<PathKitExt> clazz = PathKitExt.class;
            String path = clazz.getProtectionDomain().getCodeSource().getLocation().getPath();
            path = URLDecoder.decode(path, "UTF-8");
            path = path.trim();
            File file = new File(path);
            if (file.isFile()) {
                path = file.getParent();
            }
            locationPath = path = PathKitExt.removeSlashEnd(path);
            return locationPath;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getRootClassPath() {
        if (rootClassPath == null) {
            rootClassPath = PathKitExt.buildRootClassPath();
        }
        return rootClassPath;
    }

    private static String buildRootClassPath() {
        String classPathDirEndsWith_classes = PathKitExt.getClassPathDirEndsWith_classes();
        if (classPathDirEndsWith_classes != null) {
            return classPathDirEndsWith_classes;
        }
        String path = PathKitExt.getLocationPath();
        return PathKitExt.processRootClassPath(path);
    }

    private static String getClassPathDirEndsWith_classes() {
        String[] classPathDirs = PathKitExt.getClassPathDirs();
        if (classPathDirs == null || classPathDirs.length == 0) {
            return null;
        }
        for (String dir : classPathDirs) {
            if (dir == null || (dir = PathKitExt.removeSlashEnd(dir.trim())) == null || !dir.endsWith("classes")) continue;
            return dir;
        }
        return null;
    }

    private static String processRootClassPath(String path) {
        if (path.endsWith("classes")) {
            return path;
        }
        if (path.endsWith(File.separatorChar + "lib")) {
            path = path.substring(0, path.lastIndexOf(File.separatorChar));
        }
        return new File(path + File.separator + "config").getAbsolutePath();
    }

    public static String removeSlashEnd(String path) {
        if (path.endsWith(File.separator)) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static String getWebRootPath() {
        if (webRootPath == null) {
            webRootPath = PathKitExt.buildWebRootPath();
        }
        return webRootPath;
    }

    private static String buildWebRootPath() {
        String classPathDirEndsWith_classes = PathKitExt.getClassPathDirEndsWith_classes();
        if (classPathDirEndsWith_classes != null) {
            return classPathDirEndsWith_classes;
        }
        String path = PathKitExt.getLocationPath();
        return PathKitExt.processWebRootPath(path);
    }

    private static String processWebRootPath(String path) {
        if (path.endsWith("classes")) {
            return path;
        }
        if (path.endsWith(File.separatorChar + "lib")) {
            path = path.substring(0, path.lastIndexOf(File.separatorChar));
        }
        return new File(path + File.separator + "webapp").getAbsolutePath();
    }

    public static String[] getClassPathDirs() {
        if (classPathDirs == null) {
            classPathDirs = PathKitExt.buildClassPathDirs();
        }
        return classPathDirs;
    }

    private static String[] buildClassPathDirs() {
        String[] classPathArray;
        ArrayList<String> list = new ArrayList<String>();
        for (String classPath : classPathArray = System.getProperty("java.class.path").split(File.pathSeparator)) {
            File file;
            if ((classPath = classPath.trim()).startsWith("./")) {
                classPath = classPath.substring(2);
            }
            if (!(file = new File(classPath)).exists() || !file.isDirectory()) continue;
            if (!classPath.endsWith(File.separator)) {
                classPath = classPath + File.separator;
            }
            list.add(classPath);
        }
        return list.toArray(new String[list.size()]);
    }
}

