/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.app;

import com.jfinal.config.Interceptors;
import com.jfinal.config.Plugins;
import com.jfinal.core.JFinal;
import com.jfinal.plugin.IPlugin;
import io.jboot.app.ApplicationUtil;
import io.jboot.app.JbootApplicationConfig;
import io.jboot.app.PathKitExt;
import io.jboot.app.config.JbootConfigManager;
import io.jboot.core.JbootCoreConfig;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class JbootSimpleApplication {
    private static final ReentrantLock LOCK = new ReentrantLock();
    private static final Condition STOP = LOCK.newCondition();

    public static void main(String[] args) {
        JbootSimpleApplication.run(args);
    }

    public static void setBootArg(String key, Object value) {
        JbootConfigManager.setBootArg(key, value);
    }

    public static void run(String[] args) {
        long startTimeMillis = System.currentTimeMillis();
        JbootApplicationConfig appConfig = ApplicationUtil.getAppConfig(args);
        ApplicationUtil.printBannerInfo(appConfig);
        ApplicationUtil.printApplicationInfo(appConfig);
        ApplicationUtil.printClassPath();
        JbootCoreConfig coreConfig = new JbootCoreConfig();
        new SimpleServer(coreConfig, startTimeMillis).start();
    }

    static class SimpleServer
    extends Thread {
        private final JbootCoreConfig coreConfig;
        private final long startTimeMillis;
        private final Plugins plugins = new Plugins();
        private final Interceptors interceptors = new Interceptors();

        public SimpleServer(JbootCoreConfig coreConfig, long startTimeMillis) {
            this.coreConfig = coreConfig;
            this.startTimeMillis = startTimeMillis;
            this.doInitJFinalPathKit();
            this.doInitCoreConfig();
        }

        private void doInitJFinalPathKit() {
            try {
                Class<?> c = JbootSimpleApplication.class.getClassLoader().loadClass("com.jfinal.kit.PathKit");
                Method setWebRootPath = c.getMethod("setWebRootPath", String.class);
                String webRootPath = PathKitExt.getWebRootPath();
                setWebRootPath.invoke(null, webRootPath);
                Method setRootClassPath = c.getMethod("setRootClassPath", String.class);
                String rootClassPath = PathKitExt.getRootClassPath();
                setRootClassPath.invoke(null, rootClassPath);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        private void doInitCoreConfig() {
            this.coreConfig.configConstant(JFinal.me().getConstants());
            this.coreConfig.configInterceptor(this.interceptors);
            this.coreConfig.configPlugin(this.plugins);
            this.startPlugins();
            this.coreConfig.onStart();
        }

        private void startPlugins() {
            List pluginList = this.plugins.getPluginList();
            if (pluginList == null) {
                return;
            }
            for (IPlugin plugin : pluginList) {
                try {
                    if (plugin.start()) continue;
                    String message = "Plugin start error: " + plugin.getClass().getName();
                    throw new RuntimeException(message);
                }
                catch (Exception e) {
                    String message = "Plugin start error: " + plugin.getClass().getName() + ". \n" + e.getMessage();
                    throw new RuntimeException(message, e);
                }
            }
        }

        @Override
        public void run() {
            String seconds = new DecimalFormat("#.#").format((float)(System.currentTimeMillis() - this.startTimeMillis) / 1000.0f);
            System.out.println("JbootApplication has started in " + seconds + " seconds. Welcome To The Jboot World (^_^)\n\n");
            this.initShutdownHook();
            this.startAwait();
        }

        private void initShutdownHook() {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                System.out.println("\nJbootApplication shutdown, please wait ...... ");
                try {
                    this.coreConfig.onStop();
                }
                catch (Exception e) {
                    System.out.println("JbootApplication shutdown exception: " + e.toString());
                }
                System.out.println("JbootApplication has exited, all services stopped.");
                try {
                    LOCK.lock();
                    STOP.signal();
                }
                finally {
                    LOCK.unlock();
                }
            }, "jboot-simple-application-hook"));
        }

        private void startAwait() {
            try {
                LOCK.lock();
                STOP.await();
            }
            catch (InterruptedException e) {
                System.out.println("JbootApplication has stopped, interrupted by other thread!");
            }
            finally {
                LOCK.unlock();
            }
        }
    }
}

