/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.app;

import io.jboot.app.config.JbootConfigManager;
import io.jboot.utils.FileScanner;
import io.jboot.utils.StrUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class JbootResourceLoader {
    private String resourcePathName;
    private List<FileScanner> scanners = new ArrayList<FileScanner>();

    public JbootResourceLoader() {
        String pathName = JbootConfigManager.me().getConfigValue("jboot.app.resourcePathName");
        this.resourcePathName = StrUtil.obtainDefault(pathName, "webapp");
    }

    public JbootResourceLoader(String resourcePathName) {
        this.resourcePathName = StrUtil.requireNonBlank(resourcePathName, "Resource path name must not be blank.");
    }

    public void start() {
        try {
            URL url = JbootResourceLoader.class.getClassLoader().getResource("");
            if (url == null || url.toString().endsWith(".jar!/")) {
                return;
            }
            String classPath = url.toURI().getPath();
            File srcRootPath = new File(classPath, "../..").getCanonicalFile();
            while (new File(srcRootPath.getParent(), "pom.xml").exists()) {
                srcRootPath = srcRootPath.getParentFile();
            }
            ArrayList<File> resourcesDirs = new ArrayList<File>();
            this.findResourcesPath(srcRootPath, resourcesDirs);
            for (File resourcesDir : resourcesDirs) {
                this.startNewScanner(resourcesDir.getCanonicalFile(), classPath);
            }
            Runtime.getRuntime().addShutdownHook(new Thread(() -> this.stop()));
            System.err.println("JbootResourceLoader started, Watched resource path name : " + this.resourcePathName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stop() {
        this.scanners.forEach(fileScanner -> fileScanner.stop());
        System.out.println("JbootResourceLoader stoped ......");
    }

    private void findResourcesPath(File root, List<File> resourcesDirs) {
        File[] dirs = root.listFiles(pathname -> pathname.isDirectory());
        if (dirs == null || dirs.length == 0) {
            return;
        }
        for (File dir : dirs) {
            File parentFile = dir.getParentFile();
            if (parentFile == null) {
                return;
            }
            if (dir.getName().equals(this.resourcePathName) && parentFile.getName().equals("main")) {
                resourcesDirs.add(dir);
                continue;
            }
            this.findResourcesPath(dir, resourcesDirs);
        }
    }

    private void startNewScanner(File resourcesDir, final String classPath) throws IOException {
        final String path = "main" + File.separator + this.resourcePathName + File.separator;
        FileScanner scanner = new FileScanner(resourcesDir.getCanonicalPath(), 5){

            @Override
            public void onChange(String action, String file) {
                if ("init".equals(action)) {
                    return;
                }
                int indexOf = file.indexOf(path);
                File target = new File(classPath, JbootResourceLoader.this.resourcePathName + File.separator + file.substring(indexOf + path.length()));
                System.err.println("JbootResourceLoader " + action + " : " + target);
                if ("delete".equals(action)) {
                    target.delete();
                } else {
                    try {
                        FileUtils.copyFile((File)new File(file), (File)target);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        scanner.start();
        this.scanners.add(scanner);
    }
}

