/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.app;

import com.jfinal.server.undertow.UndertowConfig;
import com.jfinal.server.undertow.UndertowServer;
import com.jfinal.server.undertow.WebBuilder;
import io.jboot.app.ApplicationUtil;
import io.jboot.app.HttpContentTypes;
import io.jboot.app.JbootApplicationConfig;
import io.jboot.app.JbootResourceLoader;
import io.jboot.app.JbootWebBuilderConfiger;
import io.jboot.app.config.JbootConfigManager;
import io.jboot.app.undertow.JbootUndertowConfig;
import io.jboot.app.undertow.JbootUndertowServer;
import io.jboot.utils.StrUtil;
import io.undertow.Undertow;
import java.util.function.Consumer;
import javax.servlet.DispatcherType;

public class JbootApplication {
    public static void main(String[] args) {
        JbootApplication.run(args);
    }

    public static void run(String[] args) {
        JbootApplication.start(JbootApplication.createServer(args));
    }

    public static void run(String[] args, JbootWebBuilderConfiger configer) {
        JbootApplication.start(JbootApplication.createServer(args, configer));
    }

    public static void start(UndertowServer server) {
        server.start();
        String resourceLoaderEnable = JbootConfigManager.me().getConfigValue("jboot.app.resourceLoaderEnable");
        if (ApplicationUtil.isDevMode() && !"false".equalsIgnoreCase(resourceLoaderEnable)) {
            new JbootResourceLoader().start();
        }
    }

    public static void setBootArg(String key, Object value) {
        JbootConfigManager.setBootArg(key, value);
    }

    public static UndertowServer createServer(String[] args) {
        JbootApplicationConfig appConfig = ApplicationUtil.getAppConfig(args);
        return JbootApplication.createServer(appConfig, JbootApplication.createUndertowConfig(appConfig), null, null);
    }

    public static UndertowServer createServer(String[] args, JbootWebBuilderConfiger configer) {
        JbootApplicationConfig appConfig = ApplicationUtil.getAppConfig(args);
        return JbootApplication.createServer(appConfig, JbootApplication.createUndertowConfig(appConfig), configer);
    }

    public static UndertowServer createServer(String[] args, JbootWebBuilderConfiger configer, Consumer<Undertow.Builder> builder) {
        JbootApplicationConfig appConfig = ApplicationUtil.getAppConfig(args);
        return JbootApplication.createServer(appConfig, JbootApplication.createUndertowConfig(appConfig), configer, builder);
    }

    public static UndertowServer createServer(String[] args, Consumer<Undertow.Builder> builder) {
        JbootApplicationConfig appConfig = ApplicationUtil.getAppConfig(args);
        return JbootApplication.createServer(appConfig, JbootApplication.createUndertowConfig(appConfig), null, builder);
    }

    public static UndertowServer createServer(JbootApplicationConfig appConfig, UndertowConfig undertowConfig, JbootWebBuilderConfiger configer) {
        return JbootApplication.createServer(appConfig, undertowConfig, configer, null);
    }

    public static UndertowServer createServer(JbootApplicationConfig appConfig, UndertowConfig undertowConfig, JbootWebBuilderConfiger configer, Consumer<Undertow.Builder> builder) {
        ApplicationUtil.printBannerInfo(appConfig);
        ApplicationUtil.printApplicationInfo(appConfig);
        ApplicationUtil.printClassPath();
        return new JbootUndertowServer(undertowConfig).configWeb(webBuilder -> {
            JbootApplication.tryAddContenTypes(webBuilder);
            JbootApplication.tryAddMetricsSupport(webBuilder);
            JbootApplication.tryAddShiroSupport(webBuilder);
            JbootApplication.tryAddWebSocketSupport(webBuilder);
            if (configer != null) {
                configer.onConfig((WebBuilder)webBuilder);
            }
        }).onStart(builder);
    }

    public static UndertowConfig createUndertowConfig(JbootApplicationConfig appConfig) {
        JbootUndertowConfig undertowConfig = new JbootUndertowConfig(appConfig.getJfinalConfig());
        undertowConfig.addSystemClassPrefix("io.jboot.app");
        undertowConfig.addHotSwapClassPrefix("io.jboot");
        return undertowConfig;
    }

    private static void tryAddContenTypes(WebBuilder webBuilder) {
        HttpContentTypes.init(webBuilder.getDeploymentInfo());
    }

    private static void tryAddMetricsSupport(WebBuilder webBuilder) {
        String url = ApplicationUtil.getConfigValue("jboot.metric.adminServletMapping");
        String reporter = ApplicationUtil.getConfigValue("jboot.metric.reporter");
        if (url != null && reporter != null) {
            webBuilder.addServlet("MetricsAdminServlet", "com.codahale.metrics.servlets.AdminServlet").addServletMapping("MetricsAdminServlet", url.endsWith("/*") ? url : url + "/*");
            webBuilder.addListener("io.jboot.support.metric.JbootMetricServletContextListener");
            webBuilder.addListener("io.jboot.support.metric.JbootHealthCheckServletContextListener");
        }
    }

    private static void tryAddShiroSupport(WebBuilder webBuilder) {
        String iniConfig = ApplicationUtil.getConfigValue("jboot.shiro.ini");
        if (iniConfig != null) {
            String urlMapping = ApplicationUtil.getConfigValue("jboot.shiro.urlMapping");
            if (urlMapping == null) {
                urlMapping = "/*";
            }
            String filterClass = StrUtil.defaultIfBlank((String)ApplicationUtil.getConfigValue("jboot.shiro.filter"), (String)"io.jboot.support.shiro.JbootShiroFilter");
            webBuilder.addListener("org.apache.shiro.web.env.EnvironmentLoaderListener");
            webBuilder.addFilter("shiro", filterClass).addFilterUrlMapping("shiro", urlMapping, DispatcherType.REQUEST);
            webBuilder.getDeploymentInfo().addInitParameter("shiroEnvironmentClass", "io.jboot.support.shiro.JbootShiroWebEnvironment");
        }
    }

    private static void tryAddWebSocketSupport(WebBuilder webBuilder) {
        String websocketEndpoint = ApplicationUtil.getConfigValue("jboot.web.webSocketEndpoint");
        if (websocketEndpoint != null && websocketEndpoint.trim().length() > 0) {
            String[] classStrings;
            for (String c : classStrings = websocketEndpoint.split(",")) {
                webBuilder.addWebSocketEndpoint(c.trim());
            }
        }
    }
}

