/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.app;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

class Banner {
    Banner() {
    }

    public static String getText(String file) {
        String bannerFileText;
        File bannerFile = new File(Banner.getRootClassPath(), file);
        if (bannerFile.exists() && bannerFile.canRead() && (bannerFileText = Banner.readString(bannerFile)) != null && bannerFileText.trim().length() != 0) {
            return bannerFileText;
        }
        return "  ____  ____    ___    ___   ______ \n |    ||    \\  /   \\  /   \\ |      |\n |__  ||  o  )|     ||     ||      |\n __|  ||     ||  O  ||  O  ||_|  |_|\n/  |  ||  O  ||     ||     |  |  |  \n\\  `  ||     ||     ||     |  |  |  \n \\____||_____| \\___/  \\___/   |__|  \n                                    ";
    }

    private static String getRootClassPath() {
        try {
            String path = Banner.getClassLoader().getResource("").toURI().getPath();
            return new File(path).getAbsolutePath();
        }
        catch (Exception e) {
            try {
                String path = Banner.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                path = URLDecoder.decode(path, "UTF-8");
                if (path.endsWith(File.separator)) {
                    path = path.substring(0, path.length() - 1);
                }
                if (path.endsWith(".jar")) {
                    path = path.substring(0, path.lastIndexOf("/") + 1);
                }
                return path;
            }
            catch (UnsupportedEncodingException e1) {
                throw new RuntimeException(e1);
            }
        }
    }

    private static ClassLoader getClassLoader() {
        ClassLoader ret = Thread.currentThread().getContextClassLoader();
        return ret != null ? ret : Banner.class.getClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String readString(File file) {
        String string;
        ByteArrayOutputStream baos = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = fis.read(buffer)) > 0) {
                baos.write(buffer, 0, len);
            }
            string = new String(baos.toByteArray(), "UTF-8");
        }
        catch (Exception exception) {
            Banner.close(fis, baos);
            return null;
        }
        catch (Throwable throwable) {
            Banner.close(fis, baos);
            throw throwable;
        }
        Banner.close(fis, baos);
        return string;
    }

    private static void close(InputStream is, OutputStream os) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

