/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.app;

import io.jboot.app.Banner;
import io.jboot.app.JbootApplicationConfig;
import io.jboot.app.config.JbootConfigManager;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;

public class ApplicationUtil {
    private static Boolean runInFatjar;

    static JbootApplicationConfig getAppConfig(String[] args) {
        JbootConfigManager.parseArgs(args);
        return ApplicationUtil.getConfig(JbootApplicationConfig.class);
    }

    static void printBannerInfo(JbootApplicationConfig appConfig) {
        if (appConfig.isBannerEnable()) {
            System.out.println();
            System.out.println(Banner.getText(appConfig.getBannerFile()));
            System.out.println();
        }
    }

    static void printApplicationInfo(JbootApplicationConfig appConfig) {
        System.out.println(appConfig.toString());
    }

    public static boolean runInFatjar() {
        if (runInFatjar == null) {
            runInFatjar = ApplicationUtil.buildRunInFatjar();
        }
        return runInFatjar;
    }

    private static boolean buildRunInFatjar() {
        URL url = Thread.currentThread().getContextClassLoader().getResource("");
        if (url == null) {
            return true;
        }
        if ("jar".equalsIgnoreCase(url.getProtocol())) {
            return true;
        }
        String urlStr = url.toString().toLowerCase();
        if (urlStr.endsWith(".jar!/")) {
            return true;
        }
        if (urlStr.endsWith("/config/")) {
            File urlPath = new File(url.getPath());
            return !urlPath.exists() || !urlPath.isDirectory();
        }
        return false;
    }

    static void printClassPath() {
        try {
            if (ApplicationUtil.runInFatjar()) {
                System.out.println("JbootApplication is running in fatjar.");
            } else {
                System.out.println("JbootApplication ClassPath: " + ApplicationUtil.class.getResource("/").toURI().getPath());
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    static <T> T getConfig(Class<T> clazz) {
        return JbootConfigManager.me().get(clazz);
    }

    static String getConfigValue(String key) {
        return JbootConfigManager.me().getConfigValue(key);
    }

    static boolean isDevMode() {
        return JbootConfigManager.me().isDevMode();
    }
}

