/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.apidoc;

import com.alibaba.fastjson.JSONObject;
import io.jboot.apidoc.annotation.ApiResp;
import io.jboot.utils.ClassType;
import io.jboot.utils.StrUtil;
import java.io.Serializable;
import java.util.Objects;

public class ApiResponse
implements Serializable {
    private String field;
    private String dataType;
    private ClassType classType;
    private String remarks;
    private String mock;

    public ApiResponse() {
    }

    public ApiResponse(ApiResp apiResp) {
        this.field = apiResp.field();
        this.dataType = apiResp.dataType().getSimpleName();
        this.classType = new ClassType(apiResp.dataType(), apiResp.genericTypes());
        this.remarks = apiResp.notes();
        this.mock = apiResp.mock();
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public void setDataAndClassType(Class<?> clazz) {
        this.dataType = clazz.getSimpleName();
        this.classType = new ClassType(clazz);
    }

    public ClassType getClassType() {
        return this.classType;
    }

    public void setClassType(ClassType classType) {
        this.classType = classType;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public String getMock() {
        return this.mock;
    }

    public Object getMockObject() {
        if (StrUtil.isBlank((String)this.mock)) {
            return "";
        }
        if (this.mock.startsWith("{") && this.mock.endsWith("}") || this.mock.startsWith("[") && this.mock.endsWith("]")) {
            return JSONObject.parse((String)this.mock);
        }
        if (StrUtil.isNumeric(this.mock) && (Number.class.isAssignableFrom(this.classType.getMainClass()) || this.isType(Integer.TYPE) || this.isType(Long.TYPE))) {
            return Long.parseLong(this.mock);
        }
        if (StrUtil.isDecimal(this.mock) && (Number.class.isAssignableFrom(this.classType.getMainClass()) || this.isType(Float.TYPE) || this.isType(Double.TYPE))) {
            return Double.parseDouble(this.mock);
        }
        return this.mock;
    }

    public void setMock(String mock) {
        this.mock = mock;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiResponse that = (ApiResponse)o;
        return Objects.equals(this.field, that.field);
    }

    public boolean isType(Class<?> clazz) {
        return this.classType != null && clazz == this.classType.getMainClass();
    }

    public String toString() {
        return "ApiResponse{name='" + this.field + '\'' + ", dataType='" + this.dataType + '\'' + ", remarks='" + this.remarks + '\'' + '}';
    }
}

