/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.apidoc;

import io.jboot.apidoc.HttpMethod;
import io.jboot.apidoc.annotation.ApiPara;
import io.jboot.utils.ClassType;
import io.jboot.utils.ClassUtil;
import io.jboot.utils.StrUtil;
import java.io.Serializable;

public class ApiParameter
implements Serializable {
    private String name;
    private String value;
    private String notes;
    private ClassType dataType;
    private HttpMethod[] httpMethods;
    private Boolean require;
    private Boolean notBlank;
    private Boolean notEmpty;
    private Boolean email;
    private Long min;
    private Long max;
    private String pattern;
    private String defaultValue;

    public ApiParameter() {
    }

    public ApiParameter(ApiPara apiPara, HttpMethod[] defaultMethods) {
        this.name = apiPara.name();
        this.value = apiPara.value();
        this.notes = apiPara.notes();
        this.dataType = ClassUtil.getClassType(apiPara.dataType(), null);
        this.httpMethods = apiPara.method().length == 0 ? defaultMethods : apiPara.method();
        this.require = apiPara.require();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public ClassType getDataType() {
        return this.dataType;
    }

    public void setDataType(ClassType dataType) {
        this.dataType = dataType;
    }

    public HttpMethod[] getHttpMethods() {
        return this.httpMethods;
    }

    public void setHttpMethods(HttpMethod[] httpMethods) {
        this.httpMethods = httpMethods;
    }

    public Boolean getRequire() {
        return this.require;
    }

    public void setRequire(Boolean require) {
        this.require = require;
    }

    public Boolean getNotBlank() {
        return this.notBlank;
    }

    public void setNotBlank(Boolean notBlank) {
        this.notBlank = notBlank;
    }

    public Boolean getNotEmpty() {
        return this.notEmpty;
    }

    public void setNotEmpty(Boolean notEmpty) {
        this.notEmpty = notEmpty;
    }

    public Boolean getEmail() {
        return this.email;
    }

    public void setEmail(Boolean email) {
        this.email = email;
    }

    public Long getMin() {
        return this.min;
    }

    public void setMin(Long min) {
        this.min = min;
    }

    public Long getMax() {
        return this.max;
    }

    public void setMax(Long max) {
        this.max = max;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getHttpMethodsString() {
        StringBuilder sb = new StringBuilder();
        if (this.httpMethods != null) {
            for (int i = 0; i < this.httpMethods.length; ++i) {
                sb.append(this.httpMethods[i].getValue());
                if (i == this.httpMethods.length - 1) continue;
                sb.append(", ");
            }
        }
        return sb.toString();
    }

    public String getNotesString() {
        StringBuilder sb = new StringBuilder();
        if (StrUtil.isNotBlank(this.defaultValue)) {
            sb.append("\u9ed8\u8ba4\u503c\uff1a" + this.defaultValue);
        }
        if (StrUtil.isNotBlank(this.notes)) {
            if (sb.length() > 0) {
                sb.append(" \uff1b");
            }
            sb.append(this.notes);
        }
        return sb.toString();
    }

    public String toString() {
        return "ApiParameter{name='" + this.name + '\'' + ", value='" + this.value + '\'' + ", notes='" + this.notes + '\'' + '}';
    }
}

