/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.apidoc;

import io.jboot.aop.annotation.DefaultValue;
import io.jboot.apidoc.ApiDocManager;
import io.jboot.apidoc.ApiDocUtil;
import io.jboot.apidoc.ApiParameter;
import io.jboot.apidoc.ApiResponse;
import io.jboot.apidoc.ContentType;
import io.jboot.apidoc.HttpMethod;
import io.jboot.apidoc.annotation.ApiPara;
import io.jboot.apidoc.annotation.ApiParas;
import io.jboot.utils.ClassType;
import io.jboot.utils.ClassUtil;
import io.jboot.web.json.JsonBody;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.Email;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

public class ApiOperation
implements Serializable {
    private String value;
    private String notes;
    private String paraNotes;
    private int orderNo;
    private String actionKey;
    private ContentType contentType;
    private List<ApiParameter> apiParameters;
    private ClassType retType;
    private String retMockJson;
    private Map<String, List<ApiResponse>> retRemarks;
    private Class<?> controllerClass;
    private Method method;

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public String getParaNotes() {
        return this.paraNotes;
    }

    public void setParaNotes(String paraNotes) {
        this.paraNotes = paraNotes;
    }

    public int getOrderNo() {
        return this.orderNo;
    }

    public void setOrderNo(int orderNo) {
        this.orderNo = orderNo;
    }

    public String getActionKey() {
        return this.actionKey;
    }

    public void setActionKey(String actionKey) {
        this.actionKey = actionKey;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    public List<ApiParameter> getApiParameters() {
        return this.apiParameters;
    }

    public void setApiParameters(List<ApiParameter> apiParameters) {
        this.apiParameters = apiParameters;
    }

    public void addApiParameter(ApiParameter parameter) {
        if (this.apiParameters == null) {
            this.apiParameters = new LinkedList<ApiParameter>();
        }
        this.apiParameters.add(parameter);
    }

    public boolean hasParameter() {
        return this.apiParameters != null && this.apiParameters.size() > 0;
    }

    public ClassType getRetType() {
        return this.retType;
    }

    public void setRetType(ClassType retType) {
        this.retType = retType;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public Class<?> getControllerClass() {
        return this.controllerClass;
    }

    public void setControllerClass(Class<?> controllerClass) {
        this.controllerClass = controllerClass;
    }

    public void setMethodAndInfo(Method method, String controllerPath, HttpMethod[] defaultMethods, Class<?> containerClass) {
        this.method = method;
        this.actionKey = ApiDocUtil.getActionKey(method, controllerPath);
        this.retType = ClassUtil.getClassType(method.getGenericReturnType(), this.getControllerClass());
        if (this.retType.isVoid() && containerClass != null) {
            this.retType = new ClassType(containerClass);
        }
        this.retMockJson = ApiDocManager.me().buildMockJson(this.retType, method);
        this.retRemarks = ApiDocManager.me().buildRemarks(this.retType, method);
        this.setParameters(method, defaultMethods);
    }

    private void setParameters(Method method, HttpMethod[] defaultMethods) {
        ApiPara apiPara;
        ApiParas apiParas = method.getAnnotation(ApiParas.class);
        if (apiParas != null) {
            for (ApiPara apiPara2 : apiParas.value()) {
                this.addApiParameter(new ApiParameter(apiPara2, defaultMethods));
            }
        }
        if ((apiPara = method.getAnnotation(ApiPara.class)) != null) {
            this.addApiParameter(new ApiParameter(apiPara, defaultMethods));
        }
        Parameter[] parameters = method.getParameters();
        Type[] paraTypes = method.getGenericParameterTypes();
        for (int i = 0; i < parameters.length; ++i) {
            DefaultValue defaultValue;
            Pattern pattern;
            Max max;
            Min min;
            ApiParameter apiParameter = new ApiParameter();
            Parameter parameter = parameters[i];
            apiParameter.setName(parameter.getName());
            apiParameter.setDataType(ClassUtil.getClassType(paraTypes[i], this.getControllerClass()));
            if (parameter.getAnnotation(JsonBody.class) != null) {
                apiParameter.setHttpMethods(new HttpMethod[]{HttpMethod.POST});
            } else {
                apiParameter.setHttpMethods(defaultMethods);
            }
            ApiPara paraAnnotation = parameter.getAnnotation(ApiPara.class);
            if (paraAnnotation != null) {
                apiParameter.setValue(paraAnnotation.value());
                apiParameter.setNotes(paraAnnotation.notes());
                if (paraAnnotation.method().length > 0) {
                    apiParameter.setHttpMethods(paraAnnotation.method());
                }
                if (paraAnnotation.require()) {
                    apiParameter.setNotBlank(true);
                    apiParameter.setRequire(true);
                }
            }
            if (parameter.getAnnotation(NotNull.class) != null) {
                apiParameter.setRequire(true);
            }
            if (parameter.getAnnotation(NotBlank.class) != null) {
                apiParameter.setNotBlank(true);
                apiParameter.setRequire(true);
            }
            if (parameter.getAnnotation(NotEmpty.class) != null) {
                apiParameter.setNotEmpty(true);
                apiParameter.setRequire(true);
            }
            if (parameter.getAnnotation(Email.class) != null) {
                apiParameter.setEmail(true);
                apiParameter.setRequire(true);
            }
            if ((min = parameter.getAnnotation(Min.class)) != null) {
                apiParameter.setMin(min.value());
                apiParameter.setRequire(true);
            }
            if ((max = parameter.getAnnotation(Max.class)) != null) {
                apiParameter.setMax(max.value());
                apiParameter.setRequire(true);
            }
            if ((pattern = parameter.getAnnotation(Pattern.class)) != null) {
                apiParameter.setPattern(pattern.regexp());
                apiParameter.setRequire(true);
            }
            if ((defaultValue = parameter.getAnnotation(DefaultValue.class)) != null) {
                apiParameter.setDefaultValue(defaultValue.value());
            }
            this.addApiParameter(apiParameter);
        }
    }

    public String getRetMockJson() {
        return this.retMockJson;
    }

    public void setRetMockJson(String retMockJson) {
        this.retMockJson = retMockJson;
    }

    public Map<String, List<ApiResponse>> getRetRemarks() {
        return this.retRemarks;
    }

    public void setRetRemarks(Map<String, List<ApiResponse>> retRemarks) {
        this.retRemarks = retRemarks;
    }

    public String toString() {
        return "ApiOperation{value='" + this.value + '\'' + ", notes='" + this.notes + '\'' + ", actionKey='" + this.actionKey + '\'' + '}';
    }
}

