/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.apidoc;

import com.jfinal.kit.Ret;
import com.jfinal.plugin.activerecord.Page;
import io.jboot.apidoc.ApiDocUtil;
import io.jboot.apidoc.ApiMockBuilder;
import io.jboot.apidoc.ApiResponse;
import io.jboot.utils.ClassType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApiMockBuilders {
    static ApiMockBuilder retBuilder = new ApiMockBuilder(){

        @Override
        public Object build(ClassType classType, Method method, int level) {
            ClassType[] genericTypes;
            Ret ret = Ret.ok();
            if (classType.isGeneric() && (genericTypes = classType.getGenericTypes()).length == 1) {
                Class<?> type = genericTypes[0].getMainClass();
                if (List.class.isAssignableFrom(type)) {
                    ret.set((Object)"list", this.getMockObject(genericTypes[0], method, level));
                } else if (Map.class.isAssignableFrom(type)) {
                    ret.set((Object)"map", this.getMockObject(genericTypes[0], method, level));
                } else if (Page.class.isAssignableFrom(type)) {
                    ret.set((Object)"page", this.getMockObject(genericTypes[0], method, level));
                } else {
                    ret.set((Object)"object", this.getMockObject(genericTypes[0], method, level));
                }
            }
            List<ApiResponse> responses = ApiDocUtil.getApiResponseInMethod(method);
            for (ApiResponse response : responses) {
                Object mockObject = null;
                if (level == 0 && !response.isType(Map.class) && !response.isType(Ret.class)) {
                    mockObject = this.getMockObject(response.getClassType(), method, level);
                }
                if (mockObject == null || "".equals(mockObject)) {
                    mockObject = response.getMockObject();
                }
                ret.put((Object)response.getField(), mockObject);
            }
            return ret;
        }
    };
    static ApiMockBuilder mapBuilder = new ApiMockBuilder(){

        @Override
        public Object build(ClassType classType, Method method, int level) {
            if (Ret.class.isAssignableFrom(classType.getMainClass())) {
                return null;
            }
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            if (classType.isGeneric()) {
                Object key = this.getMockObject(classType.getGenericTypes()[0], method, level);
                if (key == null) {
                    key = "key";
                }
                Object value = this.getMockObject(classType.getGenericTypes()[1], method, level);
                map.put(key, value);
            }
            List<ApiResponse> responses = ApiDocUtil.getApiResponseInMethod(method);
            for (ApiResponse response : responses) {
                Object mockObject = null;
                if (level == 0 && !response.isType(Map.class) && !response.isType(Ret.class)) {
                    mockObject = this.getMockObject(response.getClassType(), method, level);
                }
                if (mockObject == null || "".equals(mockObject)) {
                    mockObject = response.getMockObject();
                }
                map.put(response.getField(), mockObject);
            }
            return map;
        }
    };
    static ApiMockBuilder listBuilder = new ApiMockBuilder(){

        @Override
        public Object build(ClassType classType, Method method, int level) {
            ArrayList<Object> list = new ArrayList<Object>();
            if (classType.isGeneric()) {
                Object value = this.getMockObject(classType.getGenericTypes()[0], method, level);
                list.add(value);
                Object value2 = this.getMockObject(classType.getGenericTypes()[0], method, level);
                list.add(value2);
            }
            return list;
        }
    };
    static ApiMockBuilder pageBuilder = new ApiMockBuilder(){

        @Override
        public Object build(ClassType classType, Method method, int level) {
            Page page = new Page();
            page.setPageNumber(1);
            page.setPageSize(10);
            page.setTotalPage(1);
            page.setTotalRow(2);
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(this.getMockObject(classType.getGenericTypes()[0], method, level));
            list.add(this.getMockObject(classType.getGenericTypes()[0], method, level));
            page.setList(list);
            return page;
        }
    };
    static ApiMockBuilder stringBuilder = new ApiMockBuilder(){

        @Override
        public Object build(ClassType classType, Method method, int level) {
            return "";
        }
    };
}

