/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.apidoc;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.jfinal.kit.PathKit;
import com.jfinal.kit.StrKit;
import com.jfinal.plugin.activerecord.generator.ColumnMeta;
import com.jfinal.plugin.activerecord.generator.MetaBuilder;
import com.jfinal.plugin.activerecord.generator.TableMeta;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import io.jboot.Jboot;
import io.jboot.codegen.CodeGenHelpler;
import io.jboot.db.datasource.DataSourceConfig;
import io.jboot.db.driver.DriverClassNames;
import io.jboot.utils.DateUtil;
import io.jboot.utils.FileUtil;
import io.jboot.utils.StrUtil;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.temporal.Temporal;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.sql.DataSource;

public class ApiJsonGenerator {
    public static void genMockJson() {
        ApiJsonGenerator.genMockJson(new JsonGeneratorConfig("api-mock.json"));
    }

    public static void genMockJson(JsonGeneratorConfig config) {
        String oldJson;
        JSONObject rootJsonObject;
        LinkedHashMap<String, Object> root = new LinkedHashMap<String, Object>();
        File file = new File(config.getJsonFilePathPathAbsolute());
        if (file.exists() && (rootJsonObject = JSONObject.parseObject((String)(oldJson = FileUtil.readString(file)), (Feature[])new Feature[]{Feature.OrderedField})) != null && !rootJsonObject.isEmpty()) {
            for (String classOrSimpleName : rootJsonObject.keySet()) {
                root.put(classOrSimpleName, rootJsonObject.getJSONObject(classOrSimpleName));
            }
        }
        MetaBuilder builder = CodeGenHelpler.createMetaBuilder(config.getDatasource(), config.getType(), false);
        List tableMetas = builder.build();
        if (config.tableMetaFilter != null) {
            tableMetas = tableMetas.stream().filter(config.tableMetaFilter).collect(Collectors.toList());
        }
        for (TableMeta tableMeta : tableMetas) {
            LinkedHashMap<String, Object> classMockData = new LinkedHashMap<String, Object>();
            for (ColumnMeta columnMeta : tableMeta.columnMetas) {
                Object mockData = ApiJsonGenerator.createMockData(columnMeta);
                if (mockData == null || "".equals(mockData)) continue;
                classMockData.put(columnMeta.attrName, mockData);
            }
            if (classMockData.isEmpty()) continue;
            root.put(StrKit.firstCharToLowerCase((String)tableMeta.modelName), classMockData);
        }
        String jsonContent = JSONObject.toJSONString(root, (boolean)true);
        FileUtil.writeString(file, jsonContent);
        System.out.println("Gen Remarks Json File ----->" + FileUtil.getCanonicalPath(file));
    }

    private static Object createMockData(ColumnMeta columnMeta) {
        if (String.class.getName().equals(columnMeta.javaType)) {
            return columnMeta.remarks;
        }
        if (Date.class.getName().equals(columnMeta.javaType)) {
            return DateUtil.toDateTimeString(new Date());
        }
        if (ApiJsonGenerator.isTemporal(columnMeta.javaType)) {
            return DateUtil.toDateTimeString(new Date());
        }
        if (Integer.TYPE.getName().equals(columnMeta.javaType)) {
            return 1;
        }
        if (Integer.class.getName().equals(columnMeta.javaType)) {
            return 100;
        }
        if (Long.TYPE.getName().equals(columnMeta.javaType)) {
            return 1;
        }
        if (Long.class.getName().equals(columnMeta.javaType)) {
            return 100;
        }
        if (Short.TYPE.getName().equals(columnMeta.javaType)) {
            return 1;
        }
        if (Short.class.getName().equals(columnMeta.javaType)) {
            return 100;
        }
        if (BigDecimal.class.getName().equals(columnMeta.javaType)) {
            return BigDecimal.ONE;
        }
        if (BigInteger.class.getName().equals(columnMeta.javaType)) {
            return BigDecimal.ONE;
        }
        if (Boolean.TYPE.getName().equals(columnMeta.javaType)) {
            return Boolean.TRUE;
        }
        if (Boolean.class.getName().equals(columnMeta.javaType)) {
            return Boolean.TRUE;
        }
        if (Float.TYPE.getName().equals(columnMeta.javaType)) {
            return Float.valueOf(1.0f);
        }
        if (Float.class.getName().equals(columnMeta.javaType)) {
            return Float.valueOf(1.0f);
        }
        if (Double.TYPE.getName().equals(columnMeta.javaType)) {
            return 1.0;
        }
        if (Double.class.getName().equals(columnMeta.javaType)) {
            return 1.0;
        }
        return "";
    }

    private static boolean isTemporal(String javaType) {
        try {
            return Temporal.class.isAssignableFrom(Class.forName(javaType));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void genRemarksJson() {
        ApiJsonGenerator.genRemarksJson(new JsonGeneratorConfig("api-remarks.json"));
    }

    public static void genRemarksJson(JsonGeneratorConfig config) {
        String oldJson;
        JSONObject rootJsonObject;
        LinkedHashMap root = new LinkedHashMap();
        File file = new File(config.getJsonFilePathPathAbsolute());
        if (file.exists() && (rootJsonObject = JSONObject.parseObject((String)(oldJson = FileUtil.readString(file)), (Feature[])new Feature[]{Feature.OrderedField})) != null && !rootJsonObject.isEmpty()) {
            for (String classOrSimpleName : rootJsonObject.keySet()) {
                LinkedHashMap remarks = new LinkedHashMap();
                JSONObject modelRemarks = rootJsonObject.getJSONObject(classOrSimpleName);
                modelRemarks.forEach((k, v) -> remarks.put(k, String.valueOf(v)));
                root.put(classOrSimpleName, remarks);
            }
        }
        MetaBuilder builder = CodeGenHelpler.createMetaBuilder(config.getDatasource(), config.getType(), false);
        List tableMetas = builder.build();
        if (config.tableMetaFilter != null) {
            tableMetas = tableMetas.stream().filter(config.tableMetaFilter).collect(Collectors.toList());
        }
        for (TableMeta tableMeta : tableMetas) {
            LinkedHashMap<String, String> modelRemarks = new LinkedHashMap<String, String>();
            for (ColumnMeta columnMeta : tableMeta.columnMetas) {
                if (!StrUtil.isNotBlank(columnMeta.remarks)) continue;
                modelRemarks.put(columnMeta.attrName, columnMeta.remarks);
            }
            if (modelRemarks.isEmpty()) continue;
            root.put(StrKit.firstCharToLowerCase((String)tableMeta.modelName), modelRemarks);
        }
        String jsonContent = JSONObject.toJSONString(root, (boolean)true);
        FileUtil.writeString(file, jsonContent);
        System.out.println("Gen Remarks Json File ----->" + FileUtil.getCanonicalPath(file));
    }

    public static class JsonGeneratorConfig {
        private boolean useJbootDatasource = true;
        private String jdbcUrl;
        private String userName;
        private String password;
        private String type = "mysql";
        private String jsonFilePath;
        private Predicate<TableMeta> tableMetaFilter;

        public JsonGeneratorConfig() {
        }

        public JsonGeneratorConfig(String jsonFilePath) {
            this.jsonFilePath = jsonFilePath;
        }

        public boolean isUseJbootDatasource() {
            return this.useJbootDatasource;
        }

        public void setUseJbootDatasource(boolean useJbootDatasource) {
            this.useJbootDatasource = useJbootDatasource;
        }

        public String getJdbcUrl() {
            return this.jdbcUrl;
        }

        public void setJdbcUrl(String jdbcUrl) {
            this.jdbcUrl = jdbcUrl;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getJsonFilePath() {
            return this.jsonFilePath;
        }

        public void setJsonFilePath(String jsonFilePath) {
            this.jsonFilePath = jsonFilePath;
        }

        public String getJsonFilePathPathAbsolute() {
            if (FileUtil.isAbsolutePath(this.jsonFilePath)) {
                return this.jsonFilePath;
            }
            return FileUtil.getCanonicalPath(new File(PathKit.getRootClassPath(), "../../" + this.jsonFilePath));
        }

        public Predicate<TableMeta> getTableMetaFilter() {
            return this.tableMetaFilter;
        }

        public void setTableMetaFilter(Predicate<TableMeta> tableMetaFilter) {
            this.tableMetaFilter = tableMetaFilter;
        }

        public DataSource getDatasource() {
            if (this.useJbootDatasource) {
                DataSourceConfig datasourceConfig = Jboot.config(DataSourceConfig.class, "jboot.datasource");
                HikariConfig config = new HikariConfig();
                config.setJdbcUrl(datasourceConfig.getUrl());
                config.setUsername(datasourceConfig.getUser());
                config.setPassword(datasourceConfig.getPassword());
                config.setDriverClassName(datasourceConfig.getDriverClassName());
                return new HikariDataSource(config);
            }
            HikariConfig config = new HikariConfig();
            config.setJdbcUrl(this.jdbcUrl);
            config.setUsername(this.userName);
            config.setPassword(this.password);
            config.setDriverClassName(DriverClassNames.getDefaultDriverClass(this.type));
            return new HikariDataSource(config);
        }
    }
}

