/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.apidoc;

import io.jboot.apidoc.ApiOperation;
import io.jboot.utils.StrUtil;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

public class ApiDocument
implements Serializable {
    private String value;
    private String notes;
    private String filePath;
    private List<ApiOperation> apiOperations;
    private Class<?> controllerClass;

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void setFilePathByControllerPath(String controllerPath) {
        if (controllerPath == null || StrUtil.isBlank((String)controllerPath)) {
            throw new IllegalArgumentException("The request mapping path of Controller \"" + this.getControllerClass().getName() + "\" is empty.");
        }
        if ("/".equals(controllerPath)) {
            controllerPath = "index";
        } else if (controllerPath.startsWith("/")) {
            controllerPath = controllerPath.substring(1);
        }
        if (controllerPath.contains("/")) {
            controllerPath = controllerPath.replace("/", "_");
        }
        this.filePath = controllerPath;
    }

    public List<ApiOperation> getApiOperations() {
        return this.apiOperations;
    }

    public void setApiOperations(List<ApiOperation> apiOperations) {
        this.apiOperations = apiOperations;
    }

    public void addOperation(ApiOperation apiOperation) {
        if (this.apiOperations == null) {
            this.apiOperations = new LinkedList<ApiOperation>();
        }
        this.apiOperations.add(apiOperation);
    }

    public Class<?> getControllerClass() {
        return this.controllerClass;
    }

    public void setControllerClass(Class<?> controllerClass) {
        this.controllerClass = controllerClass;
    }

    public String toString() {
        return "ApiDocument{value='" + this.value + '\'' + ", notes='" + this.notes + '\'' + '}';
    }
}

