/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.apidoc;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.jfinal.config.Routes;
import com.jfinal.core.ActionKey;
import com.jfinal.core.Path;
import com.jfinal.kit.StrKit;
import io.jboot.apidoc.ApiResponse;
import io.jboot.apidoc.HttpMethod;
import io.jboot.apidoc.annotation.ApiResp;
import io.jboot.apidoc.annotation.ApiResps;
import io.jboot.core.listener.JbootAppListener;
import io.jboot.core.listener.JbootAppListenerManager;
import io.jboot.utils.AnnotationUtil;
import io.jboot.utils.StrUtil;
import io.jboot.web.controller.annotation.DeleteRequest;
import io.jboot.web.controller.annotation.GetMapping;
import io.jboot.web.controller.annotation.GetRequest;
import io.jboot.web.controller.annotation.PatchRequest;
import io.jboot.web.controller.annotation.PostMapping;
import io.jboot.web.controller.annotation.PostRequest;
import io.jboot.web.controller.annotation.PutRequest;
import io.jboot.web.controller.annotation.RequestMapping;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ApiDocUtil {
    private static Map<Class<?>, String> controllerPathMap = null;
    private static final String SLASH = "/";

    public static String getControllerPath(Class<?> controllerClass) {
        RequestMapping rm = controllerClass.getAnnotation(RequestMapping.class);
        if (rm != null) {
            return AnnotationUtil.get(rm.value());
        }
        Path path = controllerClass.getAnnotation(Path.class);
        if (path != null) {
            return AnnotationUtil.get(path.value());
        }
        PostMapping pm = controllerClass.getAnnotation(PostMapping.class);
        if (pm != null) {
            return AnnotationUtil.get(pm.value());
        }
        GetMapping gm = controllerClass.getAnnotation(GetMapping.class);
        if (gm != null) {
            return AnnotationUtil.get(gm.value());
        }
        return ApiDocUtil.tryToGetInAppListener(controllerClass);
    }

    private static String tryToGetInAppListener(Class<?> controllerClass) {
        if (controllerPathMap != null) {
            return controllerPathMap.get(controllerClass);
        }
        controllerPathMap = new HashMap();
        List<JbootAppListener> listeners = JbootAppListenerManager.me().getListeners();
        if (listeners == null || listeners.isEmpty()) {
            return null;
        }
        Routes baseRoutes = new Routes(){

            public void config() {
            }

            public Routes add(Routes childRoutes) {
                childRoutes.config();
                childRoutes.getRouteItemList().forEach(route -> controllerPathMap.put(route.getControllerClass(), route.getControllerPath()));
                return this;
            }
        };
        listeners.forEach(jbootAppListener -> jbootAppListener.onRouteConfig(baseRoutes));
        baseRoutes.getRouteItemList().forEach(route -> controllerPathMap.put(route.getControllerClass(), route.getControllerPath()));
        return controllerPathMap.get(controllerClass);
    }

    public static HttpMethod getControllerMethod(Class<?> controllerClass) {
        RequestMapping rm = controllerClass.getAnnotation(RequestMapping.class);
        if (rm != null) {
            return HttpMethod.ALL;
        }
        Path path = controllerClass.getAnnotation(Path.class);
        if (path != null) {
            return HttpMethod.ALL;
        }
        PostMapping pm = controllerClass.getAnnotation(PostMapping.class);
        if (pm != null) {
            return HttpMethod.POST;
        }
        GetMapping gm = controllerClass.getAnnotation(GetMapping.class);
        if (gm != null) {
            return HttpMethod.GET;
        }
        return HttpMethod.ALL;
    }

    public static HttpMethod[] getMethodHttpMethods(Method method, HttpMethod defaultMethod) {
        HttpMethod[] httpMethodArray;
        HashSet<HttpMethod> httpMethods = new HashSet<HttpMethod>();
        if (method.getAnnotation(GetRequest.class) != null) {
            httpMethods.add(HttpMethod.GET);
        }
        if (method.getAnnotation(PostRequest.class) != null) {
            httpMethods.add(HttpMethod.POST);
        }
        if (method.getAnnotation(PutRequest.class) != null) {
            httpMethods.add(HttpMethod.PUT);
        }
        if (method.getAnnotation(DeleteRequest.class) != null) {
            httpMethods.add(HttpMethod.DELETE);
        }
        if (method.getAnnotation(PatchRequest.class) != null) {
            httpMethods.add(HttpMethod.PATCH);
        }
        if (httpMethods.isEmpty()) {
            HttpMethod[] httpMethodArray2 = new HttpMethod[1];
            httpMethodArray = httpMethodArray2;
            httpMethodArray2[0] = defaultMethod;
        } else {
            httpMethodArray = httpMethods.toArray(new HttpMethod[0]);
        }
        return httpMethodArray;
    }

    public static String getActionKey(Method method, String controllerPath) {
        String actionKey;
        String methodName = method.getName();
        ActionKey ak = method.getAnnotation(ActionKey.class);
        if (ak != null) {
            actionKey = ak.value().trim();
            if (!actionKey.startsWith(SLASH)) {
                actionKey = actionKey.startsWith("./") ? controllerPath + actionKey.substring(1) : SLASH + actionKey;
            }
        } else {
            actionKey = methodName.equals("index") ? controllerPath : (controllerPath.equals(SLASH) ? SLASH + methodName : controllerPath + SLASH + methodName);
        }
        return actionKey;
    }

    public static List<ApiResponse> getApiResponseInMethod(Method method) {
        ApiResp apiResp;
        LinkedList<ApiResponse> retList = new LinkedList<ApiResponse>();
        ApiResps apiResps = method.getAnnotation(ApiResps.class);
        if (apiResps != null) {
            for (ApiResp apiResp2 : apiResps.value()) {
                retList.add(new ApiResponse(apiResp2));
            }
        }
        if ((apiResp = method.getAnnotation(ApiResp.class)) != null) {
            retList.add(new ApiResponse(apiResp));
        }
        return retList;
    }

    public static String prettyJson(String json) {
        if (StrUtil.isBlank((String)json)) {
            return json;
        }
        JSONObject jsonObject = null;
        try {
            jsonObject = JSONObject.parseObject((String)json, (Feature[])new Feature[]{Feature.OrderedField});
        }
        catch (Exception e) {
            return json;
        }
        return JSONObject.toJSONString((Object)jsonObject, (boolean)true);
    }

    public static String getterMethod2Field(Method getterMethod) {
        String methodName = getterMethod.getName();
        if (methodName.startsWith("get") && methodName.length() > 3) {
            return StrKit.firstCharToLowerCase((String)methodName.substring(3));
        }
        if (methodName.startsWith("is") && methodName.length() > 2) {
            return StrKit.firstCharToLowerCase((String)methodName.substring(2));
        }
        return null;
    }
}

