/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.apidoc;

import com.jfinal.template.Engine;
import io.jboot.apidoc.ApiDocConfig;
import io.jboot.apidoc.ApiDocument;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

public interface ApiDocRender {
    public static final ApiDocRender MARKDOWN_RENDER = new ApiDocRender(){
        private Engine engine = new Engine("apidoc");
        private String template = "#(\"#\") #(document.value ??)\n\n#(document.notes ??)#for(operation : document.apiOperations)\n\n\n#(\"##\") #(operation.value ??)\n#if(operation.notes)\n\n#(operation.notes ??) \n#end\n#('####') \u63a5\u53e3\u4fe1\u606f\uff1a\n- \u8bbf\u95ee\u8def\u5f84\uff1a `#(operation.actionKey ??)`\n- \u6570\u636e\u7c7b\u578b\uff1a `#(operation.contentType.value ??)`\n#if(operation.hasParameter())\n#('####') \u8bf7\u6c42\u53c2\u6570\uff1a\n\n| \u53c2\u6570 | \u540d\u79f0 | \u6570\u636e\u7c7b\u578b | \u662f\u5426\u5fc5\u987b | \u63d0\u4ea4\u65b9\u5f0f | \u63cf\u8ff0 |  \n| --- | --- | --- | --- | --- | --- |\n#for(parameter : operation.apiParameters)| #(parameter.name ??) | #(parameter.value ??) | `#(parameter.dataType ??)` | #(parameter.require ? '\u662f' : '\u5426') | #(parameter.httpMethodsString ??) | #(parameter.notesString ??) |  \n#end#end\n\n#if(operation.paraNotes)> #(operation.paraNotes ??)#end#if(operation.retType)\n\n#('####') \u6570\u636e\u54cd\u5e94\uff1a`#(operation.retType ??)`\n\n#for(item : operation.retRemarks)#(item.key ??)\n\n| \u5b57\u6bb5  | \u6570\u636e\u7c7b\u578b | \u63cf\u8ff0 |  \n| --- | --- | --- | \n#for(info : item.value)| #(info.field ??) | `#(info.classType ??)` | #(info.remarks ??) |  \n#end\n\n#end#if(operation.retMockJson)**JSON \u793a\u4f8b\uff1a**\n```json\n#(operation.retMockJson ??)\n```#end#end\n\n#end";

        @Override
        public void render(List<ApiDocument> apiDocuments, ApiDocConfig config) {
            try {
                for (ApiDocument document : apiDocuments) {
                    this.doRender(document, config);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private void doRender(ApiDocument document, ApiDocConfig config) throws IOException {
            HashMap<String, Object> templateParas = new HashMap<String, Object>();
            templateParas.put("config", config);
            templateParas.put("document", document);
            File file = new File(config.getBasePathAbsolute(), document.getFilePath() + ".md");
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            System.err.println("Jboot generated apidoc -----> " + file.getCanonicalPath());
            this.engine.getTemplateByString(this.template).render(templateParas, file);
        }
    };

    public void render(List<ApiDocument> var1, ApiDocConfig var2);
}

