/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.apidoc;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.jfinal.core.Controller;
import com.jfinal.kit.JsonKit;
import com.jfinal.kit.Ret;
import com.jfinal.kit.StrKit;
import com.jfinal.plugin.activerecord.Page;
import io.jboot.apidoc.ApiDocConfig;
import io.jboot.apidoc.ApiDocRender;
import io.jboot.apidoc.ApiDocUtil;
import io.jboot.apidoc.ApiDocument;
import io.jboot.apidoc.ApiMockBuilder;
import io.jboot.apidoc.ApiMockBuilders;
import io.jboot.apidoc.ApiOperation;
import io.jboot.apidoc.ApiResponse;
import io.jboot.apidoc.ApiRet;
import io.jboot.apidoc.HttpMethod;
import io.jboot.apidoc.annotation.Api;
import io.jboot.apidoc.annotation.ApiOper;
import io.jboot.apidoc.annotation.ApiResp;
import io.jboot.apidoc.annotation.ApiResps;
import io.jboot.utils.ClassScanner;
import io.jboot.utils.ClassType;
import io.jboot.utils.FileUtil;
import io.jboot.utils.ReflectUtil;
import io.jboot.utils.StrUtil;
import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ApiDocManager {
    private static final ApiDocManager me = new ApiDocManager();
    private ApiDocRender render = ApiDocRender.MARKDOWN_RENDER;
    private Map<String, Map<String, String>> modelFieldRemarks = new HashMap<String, Map<String, String>>();
    private Map<String, Map<String, String>> defaultModelFieldRemarks = new HashMap<String, Map<String, String>>();
    private Map<String, Object> classTypeMockDatas = new HashMap<String, Object>();
    private Map<Class<?>, ApiMockBuilder> classTypeMockBuilders = new HashMap();
    private Comparator<ApiOperation> operationComparator;

    public static ApiDocManager me() {
        return me;
    }

    private ApiDocManager() {
        this.initDefaultClassTypeMockBuilder();
    }

    private void initDefaultClassTypeMockBuilder() {
        this.addClassTypeMockBuilders(Ret.class, ApiMockBuilders.retBuilder);
        this.addClassTypeMockBuilders(Map.class, ApiMockBuilders.mapBuilder);
        this.addClassTypeMockBuilders(List.class, ApiMockBuilders.listBuilder);
        this.addClassTypeMockBuilders(Page.class, ApiMockBuilders.pageBuilder);
        this.addClassTypeMockBuilders(String.class, ApiMockBuilders.stringBuilder);
    }

    public ApiDocRender getRender() {
        return this.render;
    }

    public void setRender(ApiDocRender render) {
        this.render = render;
    }

    public Map<String, Map<String, String>> getModelFieldRemarks() {
        return this.modelFieldRemarks;
    }

    public void setModelFieldRemarks(Map<String, Map<String, String>> modelFieldRemarks) {
        this.modelFieldRemarks = modelFieldRemarks;
    }

    public void addModelFieldRemarks(String classOrSimpleName, Map<String, String> fieldNames) {
        this.modelFieldRemarks.put(classOrSimpleName, fieldNames);
    }

    public Map<String, Object> getClassTypeMockDatas() {
        return this.classTypeMockDatas;
    }

    public void setClassTypeMockDatas(Map<String, Object> classTypeMockDatas) {
        this.classTypeMockDatas = classTypeMockDatas;
    }

    public void addClassTypeMocks(String classType, Object mockData) {
        this.classTypeMockDatas.put(classType, mockData);
    }

    public Object getClassTypeMockData(String classType) {
        return this.classTypeMockDatas.get(classType);
    }

    public Comparator<ApiOperation> getOperationComparator() {
        return this.operationComparator;
    }

    public void setOperationComparator(Comparator<ApiOperation> operationComparator) {
        this.operationComparator = operationComparator;
    }

    public Map<Class<?>, ApiMockBuilder> getClassTypeMockBuilders() {
        return this.classTypeMockBuilders;
    }

    public void setClassTypeMockBuilders(Map<Class<?>, ApiMockBuilder> classTypeMockBuilders) {
        this.classTypeMockBuilders = classTypeMockBuilders;
    }

    public void addClassTypeMockBuilders(Class<?> forClass, ApiMockBuilder builder) {
        this.classTypeMockBuilders.put(forClass, builder);
    }

    String buildMockJson(ClassType classType, Method method) {
        return ApiDocUtil.prettyJson(JsonKit.toJson((Object)this.doBuildMockObject(classType, method, 0)));
    }

    Object doBuildMockObject(ClassType classType, Method method, int level) {
        Object retObject = this.getClassTypeMockData(classType.toString());
        if (retObject == null) {
            retObject = this.getClassTypeMockData(classType.getMainClass().getName());
        }
        if (retObject == null) {
            retObject = this.getClassTypeMockData(StrKit.firstCharToLowerCase((String)classType.getMainClass().getSimpleName()));
        }
        if (retObject != null) {
            return retObject;
        }
        for (Class<?> aClass : this.classTypeMockBuilders.keySet()) {
            Object object;
            if (!aClass.isAssignableFrom(classType.getMainClass()) || (object = this.classTypeMockBuilders.get(aClass).build(classType, method, level)) == null) continue;
            return object;
        }
        return null;
    }

    Map<String, List<ApiResponse>> buildRemarks(ClassType classType, Method method) {
        LinkedHashMap<String, List<ApiResponse>> retMap = new LinkedHashMap<String, List<ApiResponse>>();
        this.doBuildRemarks(retMap, classType, method, 0);
        return retMap;
    }

    private void doBuildRemarks(Map<String, List<ApiResponse>> retMap, ClassType classType, Method method, int level) {
        ClassType[] types;
        Class<?> mainClass = classType.getMainClass();
        LinkedHashSet<ApiResponse> apiResponses = new LinkedHashSet<ApiResponse>();
        this.doBuildRemarksByDefault(apiResponses, classType, method);
        List<Class<?>> dataTypeClasses = null;
        if (level == 0) {
            dataTypeClasses = this.doBuildRemarksByMethodAnnotation(apiResponses, method);
        }
        this.doBuildRemarksByConfig(apiResponses, classType, method);
        if (!apiResponses.isEmpty()) {
            retMap.put(mainClass.getSimpleName(), new LinkedList<ApiResponse>(apiResponses));
        }
        if (dataTypeClasses != null) {
            for (Class<?> dataType : dataTypeClasses) {
                this.doBuildRemarks(retMap, new ClassType(dataType), method, level + 1);
            }
        }
        if ((types = classType.getGenericTypes()) != null) {
            for (ClassType type : types) {
                this.doBuildRemarks(retMap, type, method, level + 1);
            }
        }
    }

    private void doBuildRemarksByDefault(Set<ApiResponse> apiResponses, ClassType classType, Method method1) {
        Map<String, String> defaultModelRemarks = this.defaultModelFieldRemarks.get(classType.getMainClass().getName());
        if (defaultModelRemarks == null || defaultModelRemarks.isEmpty()) {
            return;
        }
        List<Method> getterMethods = ReflectUtil.searchMethodList(classType.getMainClass(), m -> m.getParameterCount() == 0 && m.getReturnType() != Void.TYPE && Modifier.isPublic(m.getModifiers()) && (m.getName().startsWith("get") || m.getName().startsWith("is")) && !"getClass".equals(m.getName()));
        HashMap<String, Method> filedAndMethodMap = new HashMap<String, Method>();
        for (Method getterMethod : getterMethods) {
            filedAndMethodMap.put(ApiDocUtil.getterMethod2Field(getterMethod), getterMethod);
        }
        for (String key : defaultModelRemarks.keySet()) {
            ApiResponse apiResponse = new ApiResponse();
            apiResponse.setField(key);
            apiResponse.setRemarks(defaultModelRemarks.get(key));
            Method getterMethod = (Method)filedAndMethodMap.get(key);
            if (getterMethod != null) {
                apiResponse.setDataAndClassType(getterMethod.getReturnType());
            } else {
                Object value;
                Object object = this.doBuildMockObject(classType, method1, 0);
                if (object instanceof Map && (value = ((Map)object).get(key)) != null) {
                    apiResponse.setDataAndClassType(value.getClass());
                }
            }
            apiResponses.add(apiResponse);
        }
    }

    private List<Class<?>> doBuildRemarksByMethodAnnotation(Set<ApiResponse> apiResponses, Method method) {
        ApiResp apiResp;
        LinkedList<ApiResponse> apiResponses1 = new LinkedList<ApiResponse>();
        ArrayList dataTypes = new ArrayList();
        ApiResps apiResps = method.getAnnotation(ApiResps.class);
        if (apiResps != null) {
            for (ApiResp apiResp2 : apiResps.value()) {
                apiResponses1.add(new ApiResponse(apiResp2));
                dataTypes.add(apiResp2.dataType());
            }
        }
        if ((apiResp = method.getAnnotation(ApiResp.class)) != null) {
            apiResponses1.add(new ApiResponse(apiResp));
            dataTypes.add(apiResp.dataType());
        }
        apiResponses.addAll(apiResponses1);
        return dataTypes;
    }

    private void doBuildRemarksByConfig(Set<ApiResponse> apiResponses, ClassType classType, Method method1) {
        Map<String, String> configRemarks = this.getConfigRemarks(classType.getMainClass());
        if (configRemarks == null || configRemarks.isEmpty()) {
            return;
        }
        List<Method> getterMethods = ReflectUtil.searchMethodList(classType.getMainClass(), m -> m.getParameterCount() == 0 && m.getReturnType() != Void.TYPE && Modifier.isPublic(m.getModifiers()) && (m.getName().startsWith("get") || m.getName().startsWith("is")) && !"getClass".equals(m.getName()));
        HashMap<String, Method> filedAndMethodMap = new HashMap<String, Method>();
        for (Method getterMethod : getterMethods) {
            filedAndMethodMap.put(ApiDocUtil.getterMethod2Field(getterMethod), getterMethod);
        }
        for (String key : configRemarks.keySet()) {
            ApiResponse apiResponse = new ApiResponse();
            apiResponse.setField(key);
            apiResponse.setRemarks(configRemarks.get(key));
            Method getterMethod = (Method)filedAndMethodMap.get(key);
            if (getterMethod != null) {
                apiResponse.setDataAndClassType(getterMethod.getReturnType());
            } else {
                Object value;
                Object object = this.doBuildMockObject(classType, method1, 0);
                if (object instanceof Map && (value = ((Map)object).get(key)) != null) {
                    apiResponse.setDataAndClassType(value.getClass());
                }
            }
            apiResponses.add(apiResponse);
        }
    }

    private Map<String, String> getConfigRemarks(Class<?> clazz) {
        Map<String, String> ret = this.modelFieldRemarks.get(clazz.getName());
        return ret != null ? ret : this.modelFieldRemarks.get(StrKit.firstCharToLowerCase((String)clazz.getSimpleName()));
    }

    public void genDocs(ApiDocConfig config) {
        List<Class> controllerClasses = ClassScanner.scanClass(aClass -> Controller.class.isAssignableFrom((Class<?>)aClass) && aClass.getAnnotation(Api.class) != null);
        if (controllerClasses.isEmpty()) {
            return;
        }
        this.initMockJson(config);
        this.initModelRemarks(config);
        ArrayList<ApiDocument> apiDocuments = new ArrayList<ApiDocument>();
        if (config.isAllInOneEnable()) {
            ApiDocument document = new ApiDocument();
            document.setValue(config.getAllInOneTitle());
            document.setNotes(config.getAllInOneNotes());
            document.setFilePath(config.getAllInOneFilePath());
            this.buildAllInOneDocument(document, controllerClasses, config);
            apiDocuments.add(document);
        } else {
            for (Class controllerClass : controllerClasses) {
                if (StrUtil.isNotBlank(config.getPackagePrefix())) {
                    if (!controllerClass.getName().startsWith(config.getPackagePrefix())) continue;
                    apiDocuments.add(this.buildDocument(controllerClass, config));
                    continue;
                }
                apiDocuments.add(this.buildDocument(controllerClass, config));
            }
        }
        if (this.render != null) {
            this.render.render(apiDocuments, config);
        }
    }

    private void initMockJson(ApiDocConfig config) {
        File mockJsonFile = new File(config.getMockJsonPathAbsolute());
        if (mockJsonFile.exists()) {
            String mockJsonString = FileUtil.readString(mockJsonFile);
            JSONObject mockJsonObject = JSONObject.parseObject((String)mockJsonString, (Feature[])new Feature[]{Feature.OrderedField});
            for (String classTypeKey : mockJsonObject.keySet()) {
                this.classTypeMockDatas.put(classTypeKey, mockJsonObject.get((Object)classTypeKey));
            }
        }
    }

    private void initModelRemarks(ApiDocConfig config) {
        LinkedHashMap<String, String> pageRemarks = new LinkedHashMap<String, String>();
        pageRemarks.put("totalRow", "\u603b\u884c\u6570");
        pageRemarks.put("pageNumber", "\u5f53\u524d\u9875\u7801");
        pageRemarks.put("firstPage", "\u662f\u5426\u662f\u7b2c\u4e00\u9875");
        pageRemarks.put("lastPage", "\u662f\u5426\u662f\u6700\u540e\u4e00\u9875");
        pageRemarks.put("totalPage", "\u603b\u9875\u6570");
        pageRemarks.put("pageSize", "\u6bcf\u9875\u6570\u636e\u91cf");
        pageRemarks.put("list", "\u6570\u636e\u5217\u8868");
        this.defaultModelFieldRemarks.put(Page.class.getName(), pageRemarks);
        LinkedHashMap<String, String> retRemarks = new LinkedHashMap<String, String>();
        retRemarks.put("state", "\u72b6\u6001\uff0c\u6210\u529f ok\uff0c\u5931\u8d25 fail");
        this.defaultModelFieldRemarks.put(Ret.class.getName(), retRemarks);
        LinkedHashMap<String, String> apiRetRemarks = new LinkedHashMap<String, String>();
        apiRetRemarks.put("state", "\u72b6\u6001\uff0c\u6210\u529f ok\uff0c\u5931\u8d25 fail");
        apiRetRemarks.put("errorCode", "\u9519\u8bef\u7801\uff0c\u53ef\u80fd\u8fd4\u56de null");
        apiRetRemarks.put("message", "\u9519\u8bef\u6d88\u606f");
        apiRetRemarks.put("data", "\u6570\u636e");
        this.defaultModelFieldRemarks.put(ApiRet.class.getName(), apiRetRemarks);
        File modelJsonFile = new File(config.getRemarksJsonPathAbsolute());
        if (modelJsonFile.exists()) {
            String modelJsonString = FileUtil.readString(modelJsonFile);
            JSONObject modelJsonObject = JSONObject.parseObject((String)modelJsonString, (Feature[])new Feature[]{Feature.OrderedField});
            for (String classOrSimpleName : modelJsonObject.keySet()) {
                LinkedHashMap<String, String> remarks = new LinkedHashMap<String, String>();
                JSONObject modelRemarks = modelJsonObject.getJSONObject(classOrSimpleName);
                modelRemarks.forEach((k, v) -> remarks.put((String)k, String.valueOf(v)));
                this.addModelFieldRemarks(classOrSimpleName, remarks);
            }
        }
    }

    private void buildAllInOneDocument(ApiDocument document, List<Class> controllerClasses, ApiDocConfig config) {
        for (Class controllerClass : controllerClasses) {
            this.buildOperation(document, controllerClass, config);
        }
        List<ApiOperation> operations = document.getApiOperations();
        if (operations != null) {
            if (this.operationComparator != null) {
                operations.sort(this.operationComparator);
            } else {
                operations.sort(Comparator.comparing(ApiOperation::getActionKey));
            }
        }
    }

    private ApiDocument buildDocument(Class<?> controllerClass, ApiDocConfig config) {
        Api api = controllerClass.getAnnotation(Api.class);
        ApiDocument document = new ApiDocument();
        document.setControllerClass(controllerClass);
        document.setValue(api.value());
        document.setNotes(api.notes());
        document.setFilePathByControllerPath(ApiDocUtil.getControllerPath(controllerClass));
        String filePath = api.filePath();
        if (StrUtil.isNotBlank(filePath)) {
            document.setFilePath(filePath);
        }
        this.buildOperation(document, controllerClass, config);
        List<ApiOperation> operations = document.getApiOperations();
        if (operations != null) {
            if (this.operationComparator != null) {
                operations.sort(this.operationComparator);
            } else {
                operations.sort(new Comparator<ApiOperation>(){

                    @Override
                    public int compare(ApiOperation o1, ApiOperation o2) {
                        return o1.getOrderNo() == o2.getOrderNo() ? o1.getMethod().getName().compareTo(o2.getMethod().getName()) : o1.getOrderNo() - o2.getOrderNo();
                    }
                });
            }
        }
        return document;
    }

    private void buildOperation(ApiDocument document, Class<?> controllerClass, ApiDocConfig config) {
        List<Method> methods = ReflectUtil.searchMethodList(controllerClass, method -> method.getAnnotation(ApiOper.class) != null && Modifier.isPublic(method.getModifiers()));
        String controllerPath = ApiDocUtil.getControllerPath(controllerClass);
        HttpMethod defaultHttpMethod = ApiDocUtil.getControllerMethod(controllerClass);
        for (Method method2 : methods) {
            ApiOper apiOper = method2.getAnnotation(ApiOper.class);
            ApiOperation apiOperation = new ApiOperation();
            apiOperation.setControllerClass(controllerClass);
            Class<?> containerClass = apiOper.containerClass() != Void.TYPE ? apiOper.containerClass() : config.getDefaultContainerClass();
            apiOperation.setMethodAndInfo(method2, controllerPath, ApiDocUtil.getMethodHttpMethods(method2, defaultHttpMethod), containerClass);
            apiOperation.setValue(apiOper.value());
            apiOperation.setNotes(apiOper.notes());
            apiOperation.setParaNotes(apiOper.paraNotes());
            apiOperation.setOrderNo(apiOper.orderNo());
            apiOperation.setContentType(apiOper.contentType());
            document.addOperation(apiOperation);
        }
        Api api = controllerClass.getAnnotation(Api.class);
        if (api != null) {
            Class<?>[] collectClasses;
            for (Class<?> collectClass : collectClasses = api.collect()) {
                List<Method> collectMethods = ReflectUtil.searchMethodList(collectClass, method -> method.getAnnotation(ApiOper.class) != null && Modifier.isPublic(method.getModifiers()));
                String collectControllerPath = ApiDocUtil.getControllerPath(collectClass);
                HttpMethod collectDefaultHttpMethod = ApiDocUtil.getControllerMethod(controllerClass);
                for (Method method3 : collectMethods) {
                    ApiOper apiOper = method3.getAnnotation(ApiOper.class);
                    ApiOperation apiOperation = new ApiOperation();
                    apiOperation.setControllerClass(collectClass);
                    Class<?> containerClass = apiOper.containerClass() != Void.TYPE ? apiOper.containerClass() : config.getDefaultContainerClass();
                    apiOperation.setMethodAndInfo(method3, collectControllerPath, ApiDocUtil.getMethodHttpMethods(method3, collectDefaultHttpMethod), containerClass);
                    apiOperation.setValue(apiOper.value());
                    apiOperation.setNotes(apiOper.notes());
                    apiOperation.setParaNotes(apiOper.paraNotes());
                    apiOperation.setOrderNo(apiOper.orderNo());
                    apiOperation.setContentType(apiOper.contentType());
                    document.addOperation(apiOperation);
                }
            }
        }
    }
}

