/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.aop.javassist;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.InterceptorManager;
import com.jfinal.aop.Invocation;
import io.jboot.aop.InterceptorBuilderManager;
import io.jboot.aop.InterceptorCache;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javassist.util.proxy.MethodHandler;

public class JbootJavassistHandler
implements MethodHandler {
    private static final Set<String> excludedMethodName = JbootJavassistHandler.buildExcludedMethodName();
    private static final InterceptorManager interManager = InterceptorManager.me();
    private static final InterceptorBuilderManager builderManager = InterceptorBuilderManager.me();

    public Object invoke(Object self, Method originalMethod, Method proxyMethod, Object[] args) throws Throwable {
        if (excludedMethodName.contains(originalMethod.getName())) {
            return proxyMethod.invoke(self, args);
        }
        Class<?> targetClass = self.getClass().getSuperclass();
        InterceptorCache.MethodKey key = InterceptorCache.getMethodKey(targetClass, originalMethod);
        Interceptor[] inters = InterceptorCache.get(key);
        if (inters == null) {
            inters = interManager.buildServiceMethodInterceptor(targetClass, originalMethod);
            inters = builderManager.build(targetClass, originalMethod, inters);
            InterceptorCache.put(key, inters);
        }
        if (inters.length == 0) {
            return proxyMethod.invoke(self, args);
        }
        Invocation invocation = new Invocation(self, originalMethod, inters, x -> proxyMethod.invoke(self, x), args);
        invocation.invoke();
        return invocation.getReturnValue();
    }

    private static Set<String> buildExcludedMethodName() {
        Method[] methods;
        HashSet<String> excludedMethodName = new HashSet<String>(64, 0.25f);
        for (Method m : methods = Object.class.getDeclaredMethods()) {
            excludedMethodName.add(m.getName());
        }
        return excludedMethodName;
    }
}

