/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.aop.cglib;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.InterceptorManager;
import com.jfinal.aop.Invocation;
import io.jboot.aop.InterceptorBuilderManager;
import io.jboot.aop.InterceptorCache;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;

public class JbootCglibCallback
implements MethodInterceptor {
    private static final Set<String> excludedMethodName = JbootCglibCallback.buildExcludedMethodName();
    private static final InterceptorManager interManager = InterceptorManager.me();
    private static final InterceptorBuilderManager builderManager = InterceptorBuilderManager.me();

    public Object intercept(Object target, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
        if (excludedMethodName.contains(method.getName())) {
            return methodProxy.invokeSuper(target, args);
        }
        Class<?> targetClass = target.getClass().getSuperclass();
        InterceptorCache.MethodKey key = InterceptorCache.getMethodKey(targetClass, method);
        Interceptor[] inters = InterceptorCache.get(key);
        if (inters == null) {
            inters = interManager.buildServiceMethodInterceptor(targetClass, method);
            inters = builderManager.build(targetClass, method, inters);
            InterceptorCache.put(key, inters);
        }
        if (inters.length == 0) {
            return methodProxy.invokeSuper(target, args);
        }
        Invocation invocation = new Invocation(target, method, inters, x -> methodProxy.invokeSuper(target, x), args);
        invocation.invoke();
        return invocation.getReturnValue();
    }

    private static Set<String> buildExcludedMethodName() {
        Method[] methods;
        HashSet<String> excludedMethodName = new HashSet<String>(64, 0.25f);
        for (Method m : methods = Object.class.getDeclaredMethods()) {
            excludedMethodName.add(m.getName());
        }
        return excludedMethodName;
    }
}

