/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.aop;

import com.jfinal.aop.AopFactory;
import com.jfinal.aop.Inject;
import com.jfinal.core.Controller;
import com.jfinal.log.Log;
import com.jfinal.plugin.activerecord.Model;
import com.jfinal.proxy.Proxy;
import com.jfinal.proxy.ProxyFactory;
import com.jfinal.proxy.ProxyManager;
import io.jboot.aop.JbootLazyLoaderFactory;
import io.jboot.aop.annotation.Bean;
import io.jboot.aop.annotation.BeanExclude;
import io.jboot.aop.annotation.ConfigValue;
import io.jboot.aop.annotation.Configuration;
import io.jboot.aop.annotation.Lazy;
import io.jboot.aop.annotation.StaticConstruct;
import io.jboot.aop.cglib.JbootCglibProxyFactory;
import io.jboot.aop.javassist.JbootJavassistProxyFactory;
import io.jboot.app.JbootApplicationConfig;
import io.jboot.app.config.JbootConfigKit;
import io.jboot.app.config.JbootConfigManager;
import io.jboot.app.config.annotation.ConfigModel;
import io.jboot.components.event.JbootEventListener;
import io.jboot.components.mq.JbootmqMessageListener;
import io.jboot.components.rpc.Jbootrpc;
import io.jboot.components.rpc.JbootrpcManager;
import io.jboot.components.rpc.JbootrpcReferenceConfig;
import io.jboot.components.rpc.ReferenceConfigCache;
import io.jboot.components.rpc.annotation.RPCInject;
import io.jboot.db.model.JbootModel;
import io.jboot.exception.JbootException;
import io.jboot.service.JbootServiceBase;
import io.jboot.utils.AnnotationUtil;
import io.jboot.utils.ArrayUtil;
import io.jboot.utils.ClassScanner;
import io.jboot.utils.ClassUtil;
import io.jboot.utils.StrUtil;
import io.jboot.web.controller.JbootController;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;

public class JbootAopFactory
extends AopFactory {
    private static final Log LOG = Log.getLog(JbootAopFactory.class);
    private static final Class<?>[] DEFAULT_EXCLUDES_MAPPING_CLASSES = new Class[]{JbootEventListener.class, JbootmqMessageListener.class, Serializable.class};
    private static JbootAopFactory me = new JbootAopFactory();
    private boolean defaultLazyInit = false;
    private Map<String, Object> beansCache = new ConcurrentHashMap<String, Object>();
    private Map<String, Class<?>> beanNameClassesMapping = new ConcurrentHashMap();

    public static JbootAopFactory me() {
        return me;
    }

    public boolean isDefaultLazyInit() {
        return this.defaultLazyInit;
    }

    public void setDefaultLazyInit(boolean defaultLazyInit) {
        this.defaultLazyInit = defaultLazyInit;
    }

    private JbootAopFactory() {
        if ("javassist".equalsIgnoreCase(JbootApplicationConfig.get().getProxy())) {
            ProxyManager.me().setProxyFactory((ProxyFactory)new JbootJavassistProxyFactory());
        } else {
            ProxyManager.me().setProxyFactory((ProxyFactory)new JbootCglibProxyFactory());
        }
        this.setInjectSuperClass(true);
        this.initBeanMapping();
    }

    protected Object createObject(Class<?> targetClass) {
        ConfigModel configModel = targetClass.getAnnotation(ConfigModel.class);
        if (configModel != null) {
            return JbootConfigManager.me().get(targetClass);
        }
        StaticConstruct staticConstruct = targetClass.getAnnotation(StaticConstruct.class);
        if (staticConstruct != null) {
            return ClassUtil.newInstanceByStaticConstruct(targetClass, staticConstruct);
        }
        return Proxy.get(targetClass);
    }

    protected void doInject(Class<?> targetClass, Object targetObject) throws ReflectiveOperationException {
        targetClass = this.getUsefulClass(targetClass);
        this.doInjectTargetClass(targetClass, targetObject);
        this.doInvokePostConstructMethod(targetClass, targetObject);
    }

    protected void doInvokePostConstructMethod(Class<?> targetClass, Object targetObject) throws ReflectiveOperationException {
        Class<?> superClass;
        Method[] methods;
        for (Method method : methods = targetClass.getDeclaredMethods()) {
            if (method.getParameterCount() != 0 || method.getAnnotation(PostConstruct.class) == null) continue;
            method.setAccessible(true);
            method.invoke(targetObject, new Object[0]);
            break;
        }
        if (this.notSystemClass(superClass = targetClass.getSuperclass())) {
            this.doInvokePostConstructMethod(superClass, targetObject);
        }
    }

    protected void doInjectTargetClass(Class<?> targetClass, Object targetObject) throws ReflectiveOperationException {
        Class<?> superClass;
        Field[] fields = targetClass.getDeclaredFields();
        if (fields.length != 0) {
            for (Field field : fields) {
                Lazy Lazy2;
                Object fieldValue = null;
                fieldValue = this.defaultLazyInit ? this.createFieldObjectLazy(targetObject, field) : ((Lazy2 = field.getAnnotation(Lazy.class)) != null ? this.createFieldObjectLazy(targetObject, field) : this.createFieldObjectNormal(targetObject, field));
                if (fieldValue == null) continue;
                field.setAccessible(true);
                field.set(targetObject, fieldValue);
            }
        }
        if (this.injectSuperClass && this.notSystemClass(superClass = targetClass.getSuperclass())) {
            this.doInjectTargetClass(superClass, targetObject);
        }
    }

    protected Object createFieldObjectLazy(Object targetObject, Field field) throws ReflectiveOperationException {
        return JbootLazyLoaderFactory.me().getLoader().loadLazyObject(targetObject, field);
    }

    public Object createFieldObjectNormal(Object targetObject, Field field) throws ReflectiveOperationException {
        Inject inject = field.getAnnotation(Inject.class);
        if (inject != null) {
            String beanName;
            Bean bean = field.getAnnotation(Bean.class);
            String string = beanName = bean != null ? AnnotationUtil.get(bean.name()) : null;
            if (StrUtil.isNotBlank(beanName)) {
                return this.createFieldObjectByBeanName(targetObject, field, beanName);
            }
            return this.createFieldObjectByJfinalOriginal(targetObject, field, inject);
        }
        RPCInject rpcInject = field.getAnnotation(RPCInject.class);
        if (rpcInject != null) {
            return this.createFieldObjectByRPCComponent(targetObject, field, rpcInject);
        }
        ConfigValue configValue = field.getAnnotation(ConfigValue.class);
        if (configValue != null) {
            return this.createFieldObjectByConfigValue(targetObject, field, configValue);
        }
        return null;
    }

    protected boolean notSystemClass(Class clazz) {
        return clazz != JbootController.class && clazz != Controller.class && clazz != JbootServiceBase.class && clazz != Object.class && clazz != JbootModel.class && clazz != Model.class && clazz != null;
    }

    private Object createFieldObjectByBeanName(Object targetObject, Field field, String beanName) throws ReflectiveOperationException {
        Object fieldInjectedObject = this.beansCache.get(beanName);
        if (fieldInjectedObject == null) {
            Class<?> fieldInjectedClass = this.beanNameClassesMapping.get(beanName);
            if (fieldInjectedClass == null || fieldInjectedClass == Void.class) {
                fieldInjectedClass = field.getType();
            }
            fieldInjectedObject = this.doGet(fieldInjectedClass);
            this.beansCache.put(beanName, fieldInjectedObject);
        }
        return fieldInjectedObject;
    }

    private Object createFieldObjectByJfinalOriginal(Object targetObject, Field field, Inject inject) throws ReflectiveOperationException {
        Class<?> fieldInjectedClass = inject.value();
        if (fieldInjectedClass == Void.class) {
            fieldInjectedClass = field.getType();
        }
        return this.doGet(fieldInjectedClass);
    }

    private Object createFieldObjectByRPCComponent(Object targetObject, Field field, RPCInject rpcInject) {
        try {
            Class<?> fieldInjectedClass = field.getType();
            JbootrpcReferenceConfig referenceConfig = ReferenceConfigCache.getReferenceConfig(rpcInject);
            Jbootrpc jbootrpc = JbootrpcManager.me().getJbootrpc();
            return jbootrpc.serviceObtain(fieldInjectedClass, referenceConfig);
        }
        catch (NullPointerException npe) {
            LOG.error("Can not inject rpc service for \"" + field.getName() + "\" in class \"" + ClassUtil.getUsefulClass(targetObject.getClass()).getName() + "\", because @RPCInject.check ==\"true\" and target is not available. \n" + rpcInject, (Throwable)npe);
        }
        catch (Exception ex) {
            LOG.error("Can not inject rpc service for \"" + field.getName() + "\" in class \"" + ClassUtil.getUsefulClass(targetObject.getClass()).getName() + "\" \n" + rpcInject, (Throwable)ex);
        }
        return null;
    }

    private Object createFieldObjectByConfigValue(Object targetObject, Field field, ConfigValue configValue) throws IllegalAccessException {
        String key = AnnotationUtil.get(configValue.value());
        Class<?> fieldInjectedClass = field.getType();
        String value = JbootConfigManager.me().getConfigValue(key);
        Object fieldObject = null;
        if (StrUtil.isNotBlank(value)) {
            fieldObject = JbootConfigKit.convert(fieldInjectedClass, value, field.getGenericType());
        }
        if (fieldObject == null) {
            field.setAccessible(true);
            fieldObject = field.get(targetObject);
        }
        return fieldObject;
    }

    public synchronized <T> AopFactory addMapping(Class<T> from, Class<? extends T> to) {
        Class mappingClass;
        if (from == null || to == null) {
            throw new IllegalArgumentException("The parameter from and to can not be null");
        }
        if (this.mapping == null) {
            this.mapping = new HashMap(128, 0.25f);
        }
        if ((mappingClass = (Class)this.mapping.get(from)) != null) {
            if (mappingClass == to) {
                return this;
            }
            this.singletonCache.remove(mappingClass);
        }
        this.mapping.put(from, to);
        return this;
    }

    protected void setFieldValue(Field field, Object toObj, Object data) throws IllegalAccessException {
        field.setAccessible(true);
        field.set(toObj, data);
    }

    private void initBeanMapping() {
        this.initConfigurationBeansObject();
        this.initBeansMapping();
    }

    private void initConfigurationBeansObject() {
        List<Class> configurationClasses = ClassScanner.scanClassByAnnotation(Configuration.class, true);
        for (Class configurationClass : configurationClasses) {
            Method[] methods;
            Object configurationObj = ClassUtil.newInstance(configurationClass, false);
            if (configurationObj == null) {
                throw new NullPointerException("can not newInstance for class : " + configurationClass);
            }
            for (Method method : methods = configurationClass.getDeclaredMethods()) {
                Bean beanAnnotation = method.getAnnotation(Bean.class);
                if (beanAnnotation == null) continue;
                Class<?> returnType = method.getReturnType();
                if (returnType == Void.TYPE) {
                    throw new JbootException("@Bean annotation can not use for void method: " + ClassUtil.buildMethodString(method));
                }
                String beanName = StrUtil.obtainDefault(AnnotationUtil.get(beanAnnotation.name()), method.getName());
                if (this.beansCache.containsKey(beanName)) {
                    throw new JbootException("application has contains beanName \"" + beanName + "\" for " + this.getBean(beanName) + ", can not add again by method: " + ClassUtil.buildMethodString(method));
                }
                try {
                    Object methodObj = method.invoke(configurationObj, new Object[0]);
                    if (methodObj == null) continue;
                    this.beansCache.put(beanName, methodObj);
                    this.singletonCache.put(returnType, methodObj);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    private void initBeansMapping() {
        List<Class> classes = ClassScanner.scanClassByAnnotation(Bean.class, true);
        for (Class implClass : classes) {
            Bean bean = implClass.getAnnotation(Bean.class);
            String beanName = AnnotationUtil.get(bean.name());
            if (StrUtil.isNotBlank(beanName)) {
                if (this.beanNameClassesMapping.containsKey(beanName)) {
                    throw new JbootException("application has contains beanName \"" + beanName + "\" for " + this.getBean(beanName) + ", can not add for class " + implClass);
                }
                this.beanNameClassesMapping.put(beanName, implClass);
                continue;
            }
            Class<?>[] interfaceClasses = implClass.getInterfaces();
            if (interfaceClasses.length == 0) {
                this.addMapping(implClass, implClass);
                continue;
            }
            Class<?>[] excludes = this.buildExcludeClasses(implClass);
            for (Class<?> interfaceClass : interfaceClasses) {
                if (this.inExcludes(interfaceClass, excludes)) continue;
                this.addMapping(interfaceClass, implClass);
            }
        }
    }

    private Class<?>[] buildExcludeClasses(Class<?> implClass) {
        BeanExclude beanExclude = implClass.getAnnotation(BeanExclude.class);
        return beanExclude == null ? DEFAULT_EXCLUDES_MAPPING_CLASSES : ArrayUtil.concat(DEFAULT_EXCLUDES_MAPPING_CLASSES, new Class[][]{beanExclude.value()});
    }

    private boolean inExcludes(Class<?> interfaceClass, Class<?>[] excludes) {
        for (Class<?> ex : excludes) {
            if (!ex.isAssignableFrom(interfaceClass)) continue;
            return true;
        }
        return false;
    }

    public <T> T getBean(String name) {
        Object ret = this.beansCache.get(name);
        if (ret == null && this.beanNameClassesMapping.containsKey(name)) {
            try {
                ret = this.doGet(this.beanNameClassesMapping.get(name));
                this.beansCache.put(name, ret);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
        return (T)ret;
    }

    public void setBean(String name, Object obj) {
        this.beansCache.put(name, obj);
    }
}

